/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import org.tizen.emulator.manager.concurrent.overseer.CheckVT;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.ui.Messages;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.controller.ComboViewController;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;
import org.tizen.emulator.manager.vms.property.ProcessorNumProperty;
import org.tizen.emulator.manager.vms.type.CPU;

public class ProcessorsViewController
extends ComboViewController {
    private int cpuNum;
    private static final double COMBO_WIDTH = 120.0;

    public ProcessorsViewController(Item item) {
        super(item);
    }

    @Override
    public void setViewItem(ViewItem item) {
        super.setViewItem(item);
        this.comboView.setComboWidth(120.0);
        for (CPU r : CPU.values()) {
            this.comboView.addItem(r.toString());
        }
    }

    @Override
    protected void onChangedValue(Event event) {
        try {
            this.cpuNum = Integer.valueOf(this.comboView.getSelectedItem());
        }
        catch (NumberFormatException e) {
            EMLogger.getLogger().warning(e.getMessage());
        }
        this.checkValid();
        ItemEvent iEvent = new ItemEvent(this.getName(), this);
        iEvent.oldValue = "";
        iEvent.newValue = String.valueOf(this.cpuNum);
        iEvent.oldState = this.state;
        iEvent.newState = this.state;
        ViewItemController.sendChangeEvent(iEvent);
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        this.cpuNum = this.getMode() == MODE.CREATE ? ProcessorNumProperty.getDefault() : value.getIntegerValue(this.getName());
        this.selectCombo();
    }

    private void selectCombo() {
        int index = 0;
        for (int i = 0; i < this.comboView.getItemList().size(); ++i) {
            String str = this.comboView.getItemList().get(i);
            if (!str.equals(String.valueOf(this.cpuNum))) continue;
            index = i;
            break;
        }
        this.comboView.selectItem(index);
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        value.setIntegerValue(this.getName(), this.cpuNum);
    }

    @Override
    public void checkValid() {
        String msg = "";
        if (this.checkUGWarning()) {
            msg = Messages.getString("ProcessorViewItem.Error.0") + StringResources.NEW_LINE + Messages.getString("ProcessorViewItem.Error.1");
            this.comboView.setState(STATE.WARNING, msg);
        } else {
            this.comboView.setState(STATE.OK, "");
        }
    }

    private boolean checkUGWarning() {
        return CheckVT.isNonUG() && this.cpuNum > 1;
    }
}

