/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.helper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.tizen.emulator.manager.logging.EMLogger;

public class ProcessOutputReader
extends Thread {
    private BufferedReader reader;
    private List<String> msgList = new ArrayList<String>();
    private boolean readFinished;

    public List<String> getMsg() {
        return this.msgList;
    }

    public ProcessOutputReader(BufferedReader reader, String processName) {
        this.reader = reader;
        this.setDaemon(true);
    }

    public static void startFlush(Process process, String processName) {
        BufferedReader out = new BufferedReader(new InputStreamReader(process.getInputStream()));
        new ProcessOutputReader(out, processName).start();
        BufferedReader err = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        new ProcessOutputReader(err, processName).start();
    }

    public static List<String> readStdOut(Process process, String processName) {
        BufferedReader out = new BufferedReader(new InputStreamReader(process.getInputStream()));
        ProcessOutputReader reader = new ProcessOutputReader(out, processName);
        reader.start();
        while (!reader.readFinished) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return reader.getMsg();
    }

    public static List<String> readStdErr(Process process, String processName) {
        BufferedReader err = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        ProcessOutputReader reader = new ProcessOutputReader(err, processName);
        reader.start();
        while (!reader.readFinished) {
            try {
                Thread.sleep(20L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        return reader.getMsg();
    }

    @Override
    public void run() {
        try {
            String msg;
            while ((msg = this.reader.readLine()) != null) {
                this.msgList.add(msg);
            }
        }
        catch (IOException e) {
            EMLogger.getLogger().warning(e.getMessage());
        }
        finally {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                EMLogger.getLogger().warning(e.getMessage());
            }
        }
        this.readFinished = true;
    }
}

