/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.create;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import org.tizen.emulator.manager.platform.custom.CustomPlatformImageValue;
import org.tizen.emulator.manager.ui.controller.create.PropertyView;
import org.tizen.emulator.manager.ui.item.PlatformValue;
import org.tizen.emulator.manager.ui.platform.controller.BasePlatformViewController;
import org.tizen.emulator.manager.ui.platform.controller.ImageFileViewController;
import org.tizen.emulator.manager.ui.platform.controller.ImageFormatViewController;
import org.tizen.emulator.manager.ui.platform.controller.PlatformDescViewController;
import org.tizen.emulator.manager.ui.platform.controller.PlatformNameViewController;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.template.item.Item;

public class PlatformPropertyView
extends PropertyView {
    private final List<ViewItemController> items = new ArrayList<ViewItemController>();
    private PropertyValue value;
    private PropertyValue modifiedValue;
    private CustomPlatformImageValue platformValue;
    private boolean isValueSame = false;
    private boolean stateInvalid = false;
    private final EventHandler<ItemEvent> stateChangeHandler = new EventHandler<ItemEvent>(){

        @Override
        public void handleEvent(ItemEvent event) {
            if (event.newState == STATE.ERROR || event.newState == STATE.ESSENTIAL) {
                PlatformPropertyView.this.stateInvalid = true;
            } else {
                PlatformPropertyView.this.stateInvalid = false;
                for (ViewItemController item : PlatformPropertyView.this.items) {
                    if (item.getState() != STATE.ERROR && item.getState() != STATE.ESSENTIAL) continue;
                    PlatformPropertyView.this.stateInvalid = true;
                    break;
                }
            }
            if (PlatformPropertyView.this.stateInvalid || PlatformPropertyView.this.isValueSame) {
                PlatformPropertyView.this.isInvalid.set(true);
            } else {
                PlatformPropertyView.this.isInvalid.set(false);
            }
        }
    };
    private final EventHandler<ItemEvent> modifyHandler = new EventHandler<ItemEvent>(){

        @Override
        public void handleEvent(ItemEvent event) {
            if (event.controller == null || !(event.controller instanceof ViewItemController)) {
                return;
            }
            event.controller.setPropertyValue(PlatformPropertyView.this.modifiedValue);
            CustomPlatformImageValue original = (CustomPlatformImageValue)PlatformPropertyView.this.value.getData();
            CustomPlatformImageValue modified = (CustomPlatformImageValue)PlatformPropertyView.this.modifiedValue.getData();
            PlatformPropertyView.this.isValueSame = original.equals(modified);
            if (PlatformPropertyView.this.stateInvalid || PlatformPropertyView.this.isValueSame) {
                PlatformPropertyView.this.isInvalid.set(true);
            } else {
                PlatformPropertyView.this.isInvalid.set(false);
            }
        }
    };

    public PlatformPropertyView(MODE mode) {
        super(mode);
    }

    public void setPlatformValue(CustomPlatformImageValue platformValue) {
        this.platformValue = platformValue;
    }

    public void createItems() {
        ViewItemController.removeAllStateChangeEventHandler();
        this.makePlatformPropertyItems();
        this.value = new PlatformValue(this.platformValue);
        if (this.getMode() == MODE.MODIFY) {
            this.modifiedValue = new PlatformValue(this.platformValue.clone());
            this.isValueSame = true;
            this.isInvalid.set(true);
        }
        VBox vBox = new VBox();
        vBox.setPadding(new Insets(23.0, 5.0, 20.0, 20.0));
        vBox.setAlignment(Pos.TOP_LEFT);
        ScrollPane sc = this.controller.getScrollPane();
        sc.setContent((Node)vBox);
        sc.setFitToWidth(true);
        for (ViewItemController i : this.items) {
            i.makeViewItem();
            i.setMode(this.getMode());
            i.setIntializeValue(this.value);
            Pane pane = i.getViewItem().getContent();
            i.getViewItem().setTitleMinWidth(88.0);
            vBox.getChildren().add((Object)pane);
            vBox.setSpacing(10.0);
            ViewItemController.addStateChangeEventHandler(i.getName(), this.stateChangeHandler);
            if (this.getMode() != MODE.MODIFY) continue;
            ViewItemController.addChangeEventHandler(i.getName(), this.modifyHandler);
        }
        for (ViewItemController i : this.items) {
            i.checkValid();
        }
    }

    public void removeChangeEventHandler() {
        for (ViewItemController i : this.items) {
            ViewItemController.removeStateChangeEventHandler(i.getName(), this.stateChangeHandler);
            ViewItemController.removeChangeEventHandler(i.getName(), this.modifyHandler);
        }
    }

    private void makePlatformPropertyItems() {
        Item item = new Item("name", "Name");
        this.items.add(new PlatformNameViewController(item));
        item = new Item("basePlatform", "Base Platform");
        this.items.add(new BasePlatformViewController(item));
        item = new Item("imageFormat", "Image Format");
        this.items.add(new ImageFormatViewController(item));
        item = new Item("imageFile", "Image File");
        this.items.add(new ImageFileViewController(item));
        item = new Item("platformDescription", "Description");
        this.items.add(new PlatformDescViewController(item));
    }

    public CustomPlatformImageValue getPlatformValue() {
        for (ViewItemController i : this.items) {
            i.setPropertyValue(this.value);
        }
        return (CustomPlatformImageValue)this.value.getData();
    }
}

