/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.item;

import org.tizen.emulator.manager.devices.DeviceTemplateValue;
import org.tizen.emulator.manager.devices.SubDevice;
import org.tizen.emulator.manager.devices.SubDeviceItem;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.platform.Skin;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.vms.type.RESOLUTION;
import org.tizen.emulator.manager.vms.type.SKIN_SHAPE;

public class TemplateValue
implements PropertyValue {
    private final DeviceTemplateValue templateValue;
    private final Platform platform;

    public TemplateValue(DeviceTemplateValue value, Platform platform) {
        this.templateValue = value;
        this.platform = platform;
    }

    @Override
    public Object getData() {
        return this.templateValue;
    }

    @Override
    public Integer getIntegerValue(String name) {
        if (name.equals("ramSize")) {
            return this.templateValue.getRamSize();
        }
        if (name.equals("processors")) {
            return this.templateValue.getCpuCount();
        }
        return 0;
    }

    @Override
    public Double getDoubleValue(String name) {
        if (name.equals("size")) {
            return this.templateValue.getDisplaySize();
        }
        return 0.0;
    }

    @Override
    public Boolean getBooleanValue(String name) {
        return Boolean.FALSE;
    }

    @Override
    public Object getObjectValue(String name) {
        if (name.equals("resolution")) {
            return this.templateValue.getResolution();
        }
        if (name.equals("skin")) {
            return this.templateValue.getSkin();
        }
        if (name.equals("skinShape")) {
            return this.templateValue.getSkinShape();
        }
        if (name.equals("platform")) {
            return this.platform;
        }
        return null;
    }

    @Override
    public String getStringValue(String name) {
        if (name.equals("skin")) {
            return this.templateValue.getSkinPath();
        }
        if (name.equals("profile")) {
            return this.templateValue.getProfile();
        }
        if (name.equals("name")) {
            return this.templateValue.getName();
        }
        return "";
    }

    @Override
    public String getSubItemStringValue(String parentName, String subItemName) {
        for (SubDevice subDevice : this.templateValue.getAdditionalDevices()) {
            if (!subDevice.getName().equals(parentName)) continue;
            for (SubDeviceItem subDeviceItem : subDevice.getItems()) {
                if (!subDeviceItem.getId().equals(subItemName)) continue;
                return subDeviceItem.isSupport() ? "on" : "off";
            }
        }
        return "";
    }

    @Override
    public void setIntegerValue(String name, Integer value) {
        if (name.equals("ramSize")) {
            this.templateValue.setRamSize(value);
        } else if (name.equals("processors")) {
            this.templateValue.setCpuCount(value);
        }
    }

    @Override
    public void setDoubleValue(String name, Double value) {
        if (name.equals("size")) {
            this.templateValue.setDisplaySize(value);
        }
    }

    @Override
    public void setBooleanValue(String name, Boolean value) {
    }

    @Override
    public void setObjectValue(String name, Object value) {
        if (name.equals("skin")) {
            this.templateValue.setSkin((Skin)value);
        } else if (name.equals("resolution")) {
            this.templateValue.setResolution((RESOLUTION)value);
        } else if (name.equals("skinShape")) {
            this.templateValue.setSkinShape((SKIN_SHAPE)((Object)value));
        }
    }

    @Override
    public void setStringValue(String name, String value) {
        if (name.equals("skin")) {
            this.templateValue.setSkinName(value);
        }
        if (name.equals("name")) {
            this.templateValue.setName(value);
        } else if (name.equals("profile")) {
            this.templateValue.setProfile(value);
        }
    }

    @Override
    public void setSubItemStringValue(String parentName, String subItemName, String value) {
    }

    @Override
    public void setSubItemBooleanValue(String parentName, String subItemName, boolean value) {
        this.templateValue.updateSubDevice(parentName, subItemName, value);
    }
}

