/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import org.tizen.emulator.manager.devices.DeviceTemplate;
import org.tizen.emulator.manager.devices.DeviceTemplateUtil;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.controller.LabelViewController;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.template.item.Item;

public class DeviceTemplateLabelController
extends LabelViewController {
    private String templateName = "";
    private DeviceTemplate template = null;
    private final EventHandler<ItemEvent> handler = new EventHandler<ItemEvent>(){

        @Override
        public void handleEvent(ItemEvent event) {
            if (event.data instanceof DeviceTemplate) {
                DeviceTemplateLabelController.this.template = (DeviceTemplate)event.data;
                DeviceTemplateLabelController.this.templateName = DeviceTemplateLabelController.this.template.getValue().getName();
            }
            DeviceTemplateLabelController.this.label.setText(DeviceTemplateLabelController.this.templateName);
            DeviceTemplateLabelController.this.checkValid();
        }
    };

    public DeviceTemplateLabelController(Item item) {
        super(item);
        ViewItemController.addChangeEventHandler("deviceTemplate", this.handler);
    }

    @Override
    public void dispose() {
        ViewItemController.removeChangeEventHandler("deviceTemplate", this.handler);
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        this.templateName = value.getStringValue("deviceTemplate");
        if (this.templateName != null && !this.templateName.isEmpty()) {
            this.template = DeviceTemplateUtil.findDeviceTemplateByName(this.templateName, (Platform)value.getObjectValue("baseImage"));
        }
        this.label.setText(this.templateName);
        this.checkValid();
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        value.setObjectValue(this.getName(), this.template);
    }

    @Override
    public void checkValid() {
        STATE s = STATE.OK;
        s = this.template == null || this.templateName == null ? STATE.ERROR : (this.templateName != null && this.templateName.isEmpty() ? STATE.ERROR : STATE.OK);
        if (s != STATE.OK) {
            this.label.setState(s, "");
        } else if (s != this.state) {
            this.label.setState(s, "");
        }
        if (s != this.state) {
            this.setState(s);
        }
    }
}

