/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import java.io.File;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.tabview.item.DirSharingViewItem;
import org.tizen.emulator.manager.ui.tabview.item.FileViewItem;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;

public class DirSharingItemController
extends ViewItemController {
    protected DirSharingViewItem viewItem = null;

    public DirSharingItemController(Item item) {
        super(item);
    }

    @Override
    public void makeViewItem() {
        this.setViewItem(new DirSharingViewItem());
    }

    @Override
    public ViewItem getViewItem() {
        return this.viewItem;
    }

    @Override
    public void setViewItem(ViewItem item) {
        this.viewItem = item instanceof DirSharingViewItem ? (DirSharingViewItem)item : new DirSharingViewItem();
        this.viewItem.setType(FileViewItem.Type.DIR);
        this.viewItem.setTitle("Directory Sharing");
        this.viewItem.addEventHandler(EventType.Selection, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                DirSharingItemController.this.onChangedValue(event);
            }
        });
    }

    @Override
    protected void onChangedValue(Event event) {
        this.viewItem.setEnableDirSelector(this.viewItem.isSelected());
        this.checkValid();
        ItemEvent iEvent = new ItemEvent(this.getName(), this);
        iEvent.oldValue = "";
        iEvent.newValue = event.text;
        iEvent.oldState = this.state;
        iEvent.newState = this.state;
        ViewItemController.sendChangeEvent(iEvent);
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        boolean isSupport = value.getBooleanValue(this.getName());
        String path = value.getStringValue(this.getName());
        if (path == null || path.isEmpty()) {
            this.viewItem.setFile(null);
        } else {
            this.viewItem.setFile(new File(path));
        }
        this.viewItem.setSelected(isSupport);
        this.viewItem.setEnableDirSelector(isSupport);
        this.checkValid();
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        value.setStringValue(this.getName(), this.viewItem.isSelected() ? this.viewItem.getFilePath() : "");
    }

    @Override
    public void checkValid() {
        if (this.viewItem.isSelected() && (this.viewItem.getFilePath() == null || this.viewItem.getFilePath().isEmpty())) {
            this.viewItem.setFileItemState(STATE.ERROR, "Select directory for sharing");
            this.setState(STATE.ERROR);
        } else {
            this.viewItem.setFileItemState(STATE.OK, "");
            this.setState(STATE.OK);
        }
    }
}

