/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import org.tizen.emulator.manager.ui.devicetemplate.item.RamSizeViewItem;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;
import org.tizen.emulator.manager.vms.type.RAM_SIZE;

public class RamSizeViewController
extends ViewItemController {
    RamSizeViewItem viewItem;
    private int ramSize;
    private static final double COMBO_WIDTH = 120.0;

    public RamSizeViewController(Item item) {
        super(item);
    }

    @Override
    public void makeViewItem() {
        this.setViewItem(new RamSizeViewItem());
    }

    @Override
    public ViewItem getViewItem() {
        return this.viewItem;
    }

    @Override
    public void setViewItem(ViewItem item) {
        this.viewItem = item instanceof RamSizeViewItem ? (RamSizeViewItem)item : new RamSizeViewItem();
        this.viewItem.setTitle(this.getTitle());
        this.viewItem.setComboWidth(120.0);
        for (RAM_SIZE r : RAM_SIZE.values()) {
            this.viewItem.addItem(r.toString());
        }
        this.addListener();
    }

    private void addListener() {
        this.viewItem.addEventHandler(EventType.Selection, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                RamSizeViewController.this.selectedItem(event);
            }
        });
    }

    protected void selectedItem(Event event) {
        this.ramSize = Integer.valueOf(this.viewItem.getSelectedItem());
        this.onChangedValue(event);
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        this.ramSize = value.getIntegerValue(this.getName());
        this.selectCombo();
    }

    private void selectCombo() {
        int index = 0;
        for (int i = 0; i < this.viewItem.getItemList().size(); ++i) {
            String str = this.viewItem.getItemList().get(i);
            if (!str.equals(String.valueOf(this.ramSize))) continue;
            index = i;
            break;
        }
        this.viewItem.selectItem(index);
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        value.setIntegerValue(this.getName(), this.ramSize);
    }

    @Override
    public void checkValid() {
    }

    @Override
    protected void onChangedValue(Event event) {
        ItemEvent iEvent = new ItemEvent(this.getName(), this);
        iEvent.oldValue = "";
        iEvent.newValue = String.valueOf(this.ramSize);
        iEvent.oldState = this.state;
        iEvent.newState = this.state;
        ViewItemController.sendChangeEvent(iEvent);
    }
}

