/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import org.tizen.emulator.manager.devices.DeviceTemplate;
import org.tizen.emulator.manager.devices.DeviceTemplateValue;
import org.tizen.emulator.manager.devices.SubDevice;
import org.tizen.emulator.manager.devices.SubDeviceItem;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.controller.DeviceCheckLabelViewController;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.tabview.item.CheckBoxItem;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;

public class CheckBoxController
extends ViewItemController {
    private final EventHandler<ItemEvent> handler = new EventHandler<ItemEvent>(){

        @Override
        public void handleEvent(ItemEvent event) {
            if (event.oldValue.equals(event.newValue)) {
                return;
            }
            DeviceTemplate template = null;
            if (event.data instanceof DeviceTemplate) {
                template = (DeviceTemplate)event.data;
            }
            if (template != null) {
                DeviceTemplateValue value = template.getValue();
                block0: for (SubDevice subDevice : value.getAdditionalDevices()) {
                    if (!CheckBoxController.this.parent.getName().equals(subDevice.getName())) continue;
                    for (SubDeviceItem subItem : subDevice.getItems()) {
                        if (!subItem.getId().equals(CheckBoxController.this.getName())) continue;
                        CheckBoxController.this.checkBox.setCheck(subItem.isSupport());
                        break block0;
                    }
                }
            }
        }
    };
    public static final String VALUE_ON = "on";
    public static final String VALUE_OFF = "off";
    protected CheckBoxItem checkBox;

    public CheckBoxController(Item item, ViewItemController parent) {
        super(item, parent);
        if (parent instanceof DeviceCheckLabelViewController) {
            ViewItemController.addChangeEventHandler("deviceTemplate", this.handler);
        }
    }

    @Override
    public void dispose() {
        ViewItemController.removeChangeEventHandler("deviceTemplate", this.handler);
    }

    @Override
    public void makeViewItem() {
        this.setViewItem(new CheckBoxItem());
    }

    @Override
    public ViewItem getViewItem() {
        return this.checkBox;
    }

    @Override
    public void setViewItem(ViewItem item) {
        this.checkBox = item instanceof CheckBoxItem ? (CheckBoxItem)item : new CheckBoxItem();
        this.checkBox.setText(this.getTitle());
        this.checkBox.setTooltip(this.getTitle());
        this.checkBox.addEventHandler(EventType.Selection, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                CheckBoxController.this.onChangedValue(event);
            }
        });
    }

    @Override
    protected void onChangedValue(Event event) {
        ItemEvent iEvent = new ItemEvent(this.getParent().getName(), this);
        iEvent.oldValue = this.checkBox.isChecked() ? VALUE_OFF : VALUE_ON;
        iEvent.newValue = this.checkBox.isChecked() ? VALUE_ON : VALUE_OFF;
        iEvent.oldState = this.state;
        iEvent.newState = this.state;
        ViewItemController.sendChangeEvent(iEvent);
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        String check = value.getSubItemStringValue(this.parent.getName(), this.getName());
        if (check.equals(VALUE_ON)) {
            this.checkBox.setCheck(true);
        } else {
            this.checkBox.setCheck(false);
        }
        if (this.mode == MODE.DETAIL) {
            this.checkBox.setEnable(false);
        }
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        value.setSubItemStringValue(this.parent.getName(), this.getName(), this.checkBox.isChecked() ? VALUE_ON : VALUE_OFF);
    }

    @Override
    public void checkValid() {
    }
}

