/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.concurrent.overseer;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.logging.Level;
import org.tizen.emulator.manager.concurrent.overseer.Job;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;

public class CheckSDCard
extends Job {
    CheckSDCard() {
    }

    public static boolean isSDCardChecked() {
        CheckSDCard.getInstance(CheckSDCard.class);
        return true;
    }

    @Override
    public void work() {
        File dir = new File(FilePathResources.getBaseSDCardPath());
        if (!dir.exists()) {
            dir.mkdir();
        }
        for (String s : StringResources.SD_CARD) {
            Path source = Paths.get(FilePathResources.getToolEmulatorSDCardPath(), s);
            Path target = Paths.get(FilePathResources.getBaseSDCardPath(), s);
            if (!Files.exists(source, new LinkOption[0])) {
                EMLogger.getLogger().log(Level.SEVERE, "Base SDCard image is not exist !!!");
                break;
            }
            try {
                if (Files.exists(target, new LinkOption[0])) continue;
                Files.copy(source, target, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                EMLogger.getLogger().log(Level.SEVERE, "Failed to create SDCard image !!!" + StringResources.NEW_LINE + e.getMessage());
            }
        }
    }
}

