/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.devices;

import java.util.ArrayList;
import java.util.List;
import org.tizen.emulator.manager.devices.SubDeviceItem;

public class SubDevice {
    private String name = "";
    private List<SubDeviceItem> items = new ArrayList<SubDeviceItem>();

    public SubDevice() {
    }

    public SubDevice(String name) {
        if (name != null) {
            this.name = name;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<SubDeviceItem> getItems() {
        return this.items;
    }

    public void setItems(List<SubDeviceItem> items) {
        this.items = items;
    }

    public void addSubDeviceItem(SubDeviceItem item) {
        if (item == null) {
            return;
        }
        this.items.add(item);
    }

    public void addSubDeviceItem(String id, boolean isSupport) {
        if (id == null) {
            return;
        }
        SubDeviceItem item = new SubDeviceItem(id);
        item.setSupport(isSupport);
        this.items.add(item);
    }

    public void updateSubDeviceItem(String id, boolean isSupport) {
        SubDeviceItem item = this.findSubDeviceItem(id);
        if (item == null) {
            this.addSubDeviceItem(id, isSupport);
        } else {
            item.setSupport(isSupport);
        }
    }

    private SubDeviceItem findSubDeviceItem(String id) {
        for (SubDeviceItem item : this.items) {
            if (!item.getId().equals(id)) continue;
            return item;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof SubDevice)) {
            return false;
        }
        SubDevice destDevice = (SubDevice)obj;
        if (!destDevice.name.equals(this.name)) {
            return false;
        }
        for (SubDeviceItem item : this.items) {
            boolean equals = false;
            for (SubDeviceItem destItem : destDevice.getItems()) {
                if (!item.equals(destItem)) continue;
                equals = true;
                break;
            }
            if (equals) continue;
            return false;
        }
        return true;
    }

    public SubDevice clone() {
        SubDevice value = new SubDevice();
        value.setName(this.name);
        for (SubDeviceItem subItem : this.items) {
            value.getItems().add(subItem.clone());
        }
        return value;
    }
}

