/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.plugin.EMPlugin;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.tool.JAXBHelper;
import org.tizen.emulator.manager.vms.StateChangeListener;
import org.tizen.emulator.manager.vms.VMConfigurationCreator;
import org.tizen.emulator.manager.vms.VMPropertyValue;
import org.tizen.emulator.manager.vms.VMPropertyValueCreator;
import org.tizen.emulator.manager.vms.VMWorkerCommon;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;
import org.tizen.emulator.manager.vms.monitor.VMRunningChecker;
import org.tizen.emulator.manager.vms.option.LaunchConfig;
import org.tizen.emulator.manager.vms.xml.EmulatorConfiguration;

public final class VMProperty {
    public static final int MAX_NAME_LEN = 30;
    public static final String NAME_MATCH_STR = "A-Za-z0-9-_";
    public static final int MIN_DPI = 100;
    public static final int MAX_DPI = 480;
    private static List<StateChangeListener<VMProperty>> stateChangelisteners = Collections.synchronizedList(new ArrayList());
    private static List<StateChangeListener<VMProperty>> healthChangelisteners = Collections.synchronizedList(new ArrayList());
    private final Path propertyFile;
    private VMWorkerCommon worker;
    private VMPropertyValue value = null;
    private Health health = Health.NOT_CHECKED;
    private State preState = State.NOT_SET;
    private State state = State.NOT_SET;
    private long lastLaunched;

    public static void addStateChangeListener(StateChangeListener<VMProperty> listener) {
        stateChangelisteners.add(listener);
    }

    public static void removeStateChangeListener(StateChangeListener<VMProperty> listener) {
        stateChangelisteners.remove(listener);
    }

    public static void addHealthChangeListener(StateChangeListener<VMProperty> listener) {
        healthChangelisteners.add(listener);
    }

    public static void removeHealthChangeListener(StateChangeListener<VMProperty> listener) {
        healthChangelisteners.remove(listener);
    }

    static VMProperty loadFrom(Path propertyFile) {
        VMProperty property = new VMProperty(propertyFile);
        if (property.getHealth().equals((Object)Health.PLATFORM_IMAGE_BINARY_VERSION_NOT_MATCHED)) {
            try {
                EMLogger.getLogger().info("Binary version of property file dose not match the version of installed platform image. So, " + property.getPropertyValue().vmName + " is deleted.");
                property.getWorker().deleteVM();
            }
            catch (VMWorkerException e) {
                EMLogger.getLogger().warning(e.getMessage());
            }
            return null;
        }
        VMRunningChecker.checkVMLockFile(property);
        return property;
    }

    static VMProperty createNew(VMPropertyValue value) {
        assert (value != null);
        String directoryName = FilePathResources.getTizenSDKDataVmsPath() + File.separator + value.vmName;
        String propertyFilename = directoryName + File.separator + "vm_config.xml";
        Path propertyFile = Paths.get(propertyFilename, new String[0]);
        assert (Files.notExists(propertyFile, new LinkOption[0]));
        return new VMProperty(propertyFile, value);
    }

    private VMProperty(Path propertyFile) {
        this.propertyFile = propertyFile;
        this.refresh();
        this.initVMWorker();
    }

    private VMProperty(Path propertyFile, VMPropertyValue value) {
        this.propertyFile = propertyFile;
        this.setPropertyValue(value);
        this.initVMWorker();
    }

    public VMProperty modify(VMPropertyValue value) {
        this.setPropertyValue(value);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stateChanged() {
        List<StateChangeListener<VMProperty>> list = stateChangelisteners;
        synchronized (list) {
            for (StateChangeListener<VMProperty> listener : stateChangelisteners) {
                listener.stateChanged(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void healthChanged() {
        List<StateChangeListener<VMProperty>> list = healthChangelisteners;
        synchronized (list) {
            for (StateChangeListener<VMProperty> listener : healthChangelisteners) {
                listener.stateChanged(this);
            }
        }
    }

    void refresh() {
        EmulatorConfiguration element;
        if (!Files.isRegularFile(this.propertyFile, new LinkOption[0])) {
            EMLogger.getLogger().warning("Property file is not regular file.Please, check this property file - " + this.propertyFile);
        }
        if ((element = JAXBHelper.parseXML(this.propertyFile, EmulatorConfiguration.class)) == null) {
            this.setHealth(Health.CORRUPTED);
        }
        this.value = VMPropertyValueCreator.create(this, element);
        if (this.value.vmName == null) {
            return;
        }
        if (this.value.getPlatform().isNotAvailabale()) {
            EMLogger.getLogger().warning("Platform is not available: " + this.value.vmName);
            this.setHealth(Health.PLATFORM_IS_NOT_AVAILABLE);
        } else if (!this.value.isBinaryVersionMatched) {
            this.setHealth(Health.PLATFORM_IMAGE_BINARY_VERSION_NOT_MATCHED);
        }
        Path logFile = Paths.get(FilePathResources.getEmulatorLogPath(this.value.vmName), new String[0]);
        if (Files.exists(logFile, new LinkOption[0])) {
            try {
                this.lastLaunched = Files.getLastModifiedTime(logFile, new LinkOption[0]).toMillis();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.lastLaunched = 0L;
        }
    }

    public void initVMWorker() {
        if (this.getPropertyValue().getPlatform() == null) {
            return;
        }
        EMPlugin plugin = this.getPropertyValue().getPlatform().getPlugin();
        if (plugin != null) {
            this.worker = (VMWorkerCommon)plugin.newInstance("VM-Worker");
        }
        if (this.worker == null) {
            this.worker = new VMWorkerCommon();
        }
        this.worker.setVMProperty(this);
        this.worker.initLauncher();
    }

    public VMPropertyValue getPropertyValue() {
        assert (this.value != null);
        return this.value;
    }

    private void setPropertyValue(VMPropertyValue value) {
        this.value = value;
        Path outputFile = this.getPropertyFile();
        try {
            Files.createDirectories(this.getPropertyFile().resolve("..").normalize(), new FileAttribute[0]);
        }
        catch (IOException e) {
            EMLogger.getLogger().warning("Failed to create vm directory - " + outputFile + StringResources.NEW_LINE + e.getMessage());
        }
        JAXBHelper.storeXML(outputFile, VMConfigurationCreator.create(value));
        try {
            LaunchConfig.createLaunchConfig(this);
        }
        catch (VMWorkerException e) {
            EMLogger.getLogger().warning("Failed to create launch config file" + StringResources.NEW_LINE + e.getMessage());
        }
    }

    public Path getPropertyFile() {
        return this.propertyFile;
    }

    public VMWorkerCommon getWorker() {
        return this.worker;
    }

    public synchronized Health getHealth() {
        return this.health;
    }

    public synchronized boolean setHealth(Health health) {
        assert (this.health != health);
        this.health = health;
        this.healthChanged();
        return true;
    }

    public State getPreState() {
        return this.preState;
    }

    public synchronized State getState() {
        return this.state;
    }

    public synchronized boolean setState(State state) {
        assert (this.state != state);
        if (this.state == State.BUSY) {
            if (state == State.RELEASE_BUSY) {
                state = State.READY;
            } else {
                return false;
            }
        }
        switch (state) {
            case NOT_SET: {
                break;
            }
            case BUSY: {
                assert (this.state != State.RUNNING);
                break;
            }
            case READY: {
                break;
            }
            case LAUNCHING: {
                assert (this.state == State.READY);
                this.lastLaunched = new Date().getTime();
                break;
            }
            case RUNNING: {
                assert (this.state == State.LAUNCHING || this.state == State.READY);
                break;
            }
        }
        this.preState = this.state;
        this.state = state;
        this.stateChanged();
        return true;
    }

    public synchronized boolean isRunning() {
        return this.state == State.RUNNING || this.state == State.LAUNCHING;
    }

    public synchronized boolean isAvailable() {
        return this.health == Health.WELL && this.state != State.NOT_SET;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        VMProperty target = (VMProperty)obj;
        return target.getPropertyFile().equals(this.getPropertyFile());
    }

    public long getLastLaunchedTime() {
        return this.lastLaunched;
    }

    public static enum State {
        NOT_SET,
        BUSY,
        RELEASE_BUSY,
        READY,
        LAUNCHING,
        RUNNING;

    }

    public static enum Health {
        NOT_CHECKED,
        WELL,
        PLATFORM_IMAGE_BINARY_VERSION_NOT_MATCHED,
        PLATFORM_IMAGE_NOT_ACCESSIBLE,
        PLATFORM_IS_NOT_AVAILABLE,
        CORRUPTED;

    }
}

