/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import org.tizen.emulator.manager.devices.DeviceTemplate;
import org.tizen.emulator.manager.devices.DeviceTemplateValue;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.tabview.item.DeviceDisplayLabelViewItem;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;

public class DeviceDisplayViewController
extends ViewItemController {
    private final EventHandler<ItemEvent> handler = new EventHandler<ItemEvent>(){

        @Override
        public void handleEvent(ItemEvent event) {
            if (event.oldValue.equals(event.newValue)) {
                return;
            }
            DeviceTemplate template = null;
            if (event.data instanceof DeviceTemplate) {
                template = (DeviceTemplate)event.data;
            }
            if (template != null) {
                DeviceTemplateValue value = template.getValue();
                DeviceDisplayViewController.this.viewItem.setResolution(value.getResolution().toString());
                DeviceDisplayViewController.this.viewItem.setDisplaySize(value.getDisplaySize());
                DeviceDisplayViewController.this.viewItem.setSkin(value.getSkinName());
            }
            DeviceDisplayViewController.this.onChangedValue(null);
        }
    };
    private DeviceDisplayLabelViewItem viewItem;

    public DeviceDisplayViewController(Item item) {
        super(item);
        ViewItemController.addChangeEventHandler("deviceTemplate", this.handler);
    }

    @Override
    public void dispose() {
        ViewItemController.removeChangeEventHandler("deviceTemplate", this.handler);
    }

    @Override
    public void makeViewItem() {
        this.setViewItem(new DeviceDisplayLabelViewItem());
    }

    @Override
    public ViewItem getViewItem() {
        return this.viewItem;
    }

    @Override
    public void setViewItem(ViewItem item) {
        this.viewItem = item instanceof DeviceDisplayLabelViewItem ? (DeviceDisplayLabelViewItem)item : new DeviceDisplayLabelViewItem();
        this.viewItem.setTitle("Display");
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        DeviceTemplate template = (DeviceTemplate)value.getObjectValue("deviceTemplate");
        if (template == null) {
            this.viewItem.setResolution("");
            this.viewItem.setDisplaySize(0.0);
            this.viewItem.setSkin("");
        } else {
            DeviceTemplateValue templateValue = template.getValue();
            this.viewItem.setResolution(templateValue.getResolution().toString());
            this.viewItem.setDisplaySize(templateValue.getDisplaySize());
            this.viewItem.setSkin(templateValue.getSkinName());
        }
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
    }

    @Override
    public void checkValid() {
    }
}

