/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import java.util.ArrayList;
import java.util.List;
import org.tizen.emulator.manager.network.NetworkUtil;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.controller.TapDevice;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.event.IPEventType;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.tabview.item.NetTCPIPViewItem;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;
import org.tizen.emulator.manager.vms.helper.HelperClass;

public class NetTCPIPItemController
extends ViewItemController {
    private List<TapDevice> tapList = new ArrayList<TapDevice>();
    private TapDevice savedTap = null;
    private TapDevice currentTap = null;
    private NetTCPIPViewItem viewItem;
    private EventHandler<ItemEvent> handler = new EventHandler<ItemEvent>(){

        @Override
        public void handleEvent(ItemEvent event) {
            if (event.name.equals("netTapDevice")) {
                String newTap = event.newValue;
                if (NetTCPIPItemController.this.currentTap == null || !newTap.equals(NetTCPIPItemController.this.currentTap.getName())) {
                    NetTCPIPItemController.this.changeTapDevice(newTap);
                }
            } else if (event.name.equals("netConnectType")) {
                String type = event.newValue;
                NetTCPIPItemController.this.selectConnectType(type);
            }
        }
    };

    public NetTCPIPItemController(Item item) {
        super(item);
        ViewItemController.addChangeEventHandler("netTapDevice", this.handler);
        ViewItemController.addChangeEventHandler("netConnectType", this.handler);
    }

    @Override
    public void dispose() {
        ViewItemController.removeChangeEventHandler("netConnectType", this.handler);
        ViewItemController.removeChangeEventHandler("netTapDevice", this.handler);
    }

    @Override
    public void makeViewItem() {
        this.setViewItem(new NetTCPIPViewItem());
    }

    @Override
    public ViewItem getViewItem() {
        return this.viewItem;
    }

    @Override
    public void setViewItem(ViewItem item) {
        this.viewItem = item instanceof NetTCPIPViewItem ? (NetTCPIPViewItem)item : new NetTCPIPViewItem();
        this.viewItem.addEventHandler(EventType.Selection, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                NetTCPIPItemController.this.resetIPInfoWithTap();
                if (NetTCPIPItemController.this.mode == MODE.MODIFY) {
                    NetTCPIPItemController.this.onChangedValue(null);
                }
            }
        });
        this.viewItem.addEventHandler(IPEventType.IP, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                NetTCPIPItemController.this.checkIP();
                if (NetTCPIPItemController.this.mode == MODE.MODIFY) {
                    NetTCPIPItemController.this.onChangedValue(null);
                }
            }
        });
        this.viewItem.addEventHandler(IPEventType.GATEWAY, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                NetTCPIPItemController.this.checkGateway();
                if (NetTCPIPItemController.this.mode == MODE.MODIFY) {
                    NetTCPIPItemController.this.onChangedValue(null);
                }
            }
        });
        this.viewItem.addEventHandler(IPEventType.NETMASK, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                NetTCPIPItemController.this.checkSubnet();
                if (NetTCPIPItemController.this.mode == MODE.MODIFY) {
                    NetTCPIPItemController.this.onChangedValue(null);
                }
            }
        });
        this.viewItem.addEventHandler(IPEventType.DNS, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                NetTCPIPItemController.this.checkDNS();
                if (NetTCPIPItemController.this.mode == MODE.MODIFY) {
                    NetTCPIPItemController.this.onChangedValue(null);
                }
            }
        });
    }

    @Override
    protected void onChangedValue(Event event) {
        ItemEvent iEvent = new ItemEvent(this.getName(), this);
        iEvent.oldValue = "";
        iEvent.newValue = "";
        iEvent.oldState = this.state;
        iEvent.newState = this.state;
        ViewItemController.sendChangeEvent(iEvent);
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        String mac;
        String dns;
        String gateway;
        String subnet;
        String type = value.getStringValue("netConnectType");
        if (type == null || type.isEmpty()) {
            type = "NAT";
        }
        if (type.equals("NAT")) {
            this.selectConnectType(type);
            return;
        }
        String tap = value.getStringValue("netTapDevice");
        this.savedTap = tap != null && !tap.isEmpty() ? new TapDevice(tap) : new TapDevice();
        String check = value.getSubItemStringValue("netIpInfo", "useDHCP");
        this.savedTap.setUseDHCP(check.equals("on"));
        String ip = value.getSubItemStringValue("netIpInfo", "ipAddr");
        if (ip != null && !ip.isEmpty()) {
            this.savedTap.setIp(ip);
        }
        if ((subnet = value.getSubItemStringValue("netIpInfo", "subnet")) != null && !subnet.isEmpty()) {
            this.savedTap.setNetMask(subnet);
        }
        if ((gateway = value.getSubItemStringValue("netIpInfo", "gateway")) != null && !gateway.isEmpty()) {
            this.savedTap.setGateway(gateway);
        }
        if ((dns = value.getStringValue("netDns")) != null && !dns.isEmpty()) {
            this.savedTap.setDns(dns);
        }
        if ((mac = value.getStringValue("netMac")) != null && !mac.isEmpty()) {
            this.savedTap.setMac(mac);
        }
        if (this.currentTap != null && this.currentTap.getName().equals(tap)) {
            this.currentTap.copy(this.savedTap);
        }
        this.viewItem.setCheck(this.savedTap.isUseDHCP());
        this.viewItem.setEnable(true);
        this.resetIPInfoWithTap();
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        if (this.viewItem.isCheck()) {
            value.setSubItemStringValue("netIpInfo", "useDHCP", "on");
            value.setSubItemStringValue("netIpInfo", "ipAddr", "");
            value.setSubItemStringValue("netIpInfo", "subnet", "");
            value.setSubItemStringValue("netIpInfo", "gateway", "");
            value.setStringValue("netDns", "");
        } else {
            value.setSubItemStringValue("netIpInfo", "useDHCP", "off");
            value.setSubItemStringValue("netIpInfo", "ipAddr", this.viewItem.getIPAddress());
            value.setSubItemStringValue("netIpInfo", "subnet", this.viewItem.getNetMask());
            value.setSubItemStringValue("netIpInfo", "gateway", this.viewItem.getGateway());
            value.setStringValue("netDns", this.viewItem.getDNSAddress());
        }
        value.setStringValue("netMac", this.viewItem.getMACAddress());
    }

    private TapDevice findTapDevice(String name) {
        for (TapDevice tap : this.tapList) {
            if (!tap.getName().equals(name)) continue;
            return tap;
        }
        return null;
    }

    private void changeTapDevice(String newTap) {
        if (newTap.isEmpty()) {
            this.viewItem.setEnable(false);
            return;
        }
        this.viewItem.setEnable(true);
        TapDevice tap = this.findTapDevice(newTap);
        if (tap == null) {
            tap = new TapDevice(newTap);
            this.tapList.add(tap);
        }
        if (this.currentTap == null && this.savedTap != null && tap.getName().equals(this.savedTap.getName())) {
            tap.copy(this.savedTap);
        }
        this.currentTap = tap;
        this.viewItem.setCheck(this.currentTap.isUseDHCP());
        this.resetIPInfoWithTap();
        if (this.mode == MODE.MODIFY) {
            this.onChangedValue(null);
        }
    }

    private void selectConnectType(String type) {
        if (type.equals("NAT")) {
            this.viewItem.setEnable(false);
            this.initIPInfo();
        } else {
            this.viewItem.setEnable(true);
            this.resetIPInfoWithTap();
        }
    }

    private void initIPInfo() {
        this.viewItem.setIPAddress("");
        this.viewItem.setNetMask("");
        this.viewItem.setGateway("");
        this.viewItem.setDNSAddress("");
        this.viewItem.setMACAddress("");
        this.viewItem.setIPState(STATE.OK, "");
        this.viewItem.setSubnetState(STATE.OK, "");
        this.viewItem.setGatewayState(STATE.OK, "");
        this.viewItem.setDNSState(STATE.OK, "");
        this.checkValid();
    }

    private void resetIPInfoWithTap() {
        if (this.currentTap == null) {
            String savedMac = null;
            if (this.savedTap == null) {
                this.viewItem.setIPAddress("");
                this.viewItem.setNetMask("");
                this.viewItem.setGateway("");
                this.viewItem.setDNSAddress("");
            } else {
                this.viewItem.setIPAddress(this.savedTap.getIp());
                this.viewItem.setNetMask(this.savedTap.getNetMask());
                this.viewItem.setGateway(this.savedTap.getGateway());
                this.viewItem.setDNSAddress(this.savedTap.getDns());
                savedMac = this.savedTap.getMac();
            }
            if (savedMac == null || savedMac.isEmpty()) {
                this.viewItem.setMACAddress(HelperClass.getMacAddress());
            } else {
                this.viewItem.setMACAddress(savedMac);
            }
            this.viewItem.setEnableTextField(!this.viewItem.isCheck());
            this.checkValid();
            return;
        }
        if (!this.viewItem.isCheck()) {
            this.viewItem.setIPAddress(this.currentTap.getIp());
            this.viewItem.setNetMask(this.currentTap.getNetMask());
            this.viewItem.setGateway(this.currentTap.getGateway());
            this.viewItem.setDNSAddress(this.currentTap.getDns());
        } else {
            this.viewItem.setIPAddress("");
            this.viewItem.setNetMask("");
            this.viewItem.setGateway("");
            this.viewItem.setDNSAddress("");
            this.setState(STATE.OK);
        }
        this.viewItem.setMACAddress(this.currentTap.getMac());
        this.viewItem.setEnableTextField(!this.viewItem.isCheck());
        this.currentTap.setUseDHCP(this.viewItem.isCheck());
        this.checkValid();
    }

    private void checkIP() {
        if (!this.viewItem.isEnabled() || this.viewItem.isCheck()) {
            this.viewItem.setIPState(STATE.OK, "");
        } else {
            String text = this.viewItem.getIPAddress();
            if (text.isEmpty()) {
                this.viewItem.setIPState(STATE.ESSENTIAL, "");
            } else {
                String msg = NetworkUtil.checkIPString(true, text, "ipAddr");
                if (!msg.isEmpty()) {
                    this.viewItem.setIPState(STATE.ERROR, msg);
                } else {
                    if (this.currentTap != null) {
                        this.currentTap.setIp(text);
                    }
                    this.viewItem.setIPState(STATE.OK, "");
                }
            }
        }
        this.setState(this.viewItem.getState());
    }

    private void checkSubnet() {
        if (!this.viewItem.isEnabled() || this.viewItem.isCheck()) {
            this.viewItem.setSubnetState(STATE.OK, "");
        } else {
            String text = this.viewItem.getNetMask();
            if (text.isEmpty()) {
                this.viewItem.setSubnetState(STATE.ESSENTIAL, "");
            } else {
                String msg = NetworkUtil.checkIPString(true, text, "subnet");
                if (!msg.isEmpty()) {
                    this.viewItem.setSubnetState(STATE.ERROR, msg);
                } else {
                    if (this.currentTap != null) {
                        this.currentTap.setNetMask(text);
                    }
                    this.viewItem.setSubnetState(STATE.OK, "");
                }
            }
        }
        this.setState(this.viewItem.getState());
    }

    private void checkGateway() {
        if (!this.viewItem.isEnabled() || this.viewItem.isCheck()) {
            this.viewItem.setGatewayState(STATE.OK, "");
        } else {
            String text = this.viewItem.getGateway();
            if (text.isEmpty()) {
                this.viewItem.setGatewayState(STATE.ESSENTIAL, "");
            } else {
                String msg = NetworkUtil.checkIPString(true, text, "gateway");
                if (!msg.isEmpty()) {
                    this.viewItem.setGatewayState(STATE.ERROR, msg);
                } else {
                    if (this.currentTap != null) {
                        this.currentTap.setGateway(text);
                    }
                    this.viewItem.setGatewayState(STATE.OK, "");
                }
            }
        }
        this.setState(this.viewItem.getState());
    }

    private void checkDNS() {
        if (!this.viewItem.isEnabled() || this.viewItem.isCheck()) {
            this.viewItem.setDNSState(STATE.OK, "");
        } else {
            String text = this.viewItem.getDNSAddress();
            if (text.isEmpty()) {
                this.viewItem.setDNSState(STATE.ESSENTIAL, "");
            } else {
                String msg = NetworkUtil.checkIPString(true, text, "netDns");
                if (!msg.isEmpty()) {
                    this.viewItem.setDNSState(STATE.ERROR, msg);
                } else {
                    if (this.currentTap != null) {
                        this.currentTap.setDns(text);
                    }
                    this.viewItem.setDNSState(STATE.OK, "");
                }
            }
        }
        this.setState(this.viewItem.getState());
    }

    @Override
    public void checkValid() {
        this.checkIP();
        this.checkGateway();
        this.checkSubnet();
        this.checkDNS();
    }
}

