/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.console;

public class Option {
    private final String shortName;
    private final String longName;
    private String description;
    private final String defaultValue;
    private String currentValue = "";
    private final boolean isMandatory;
    private String usage = "";
    private String shortUsage = "";
    private final boolean needsExtra;
    private final String extraValueName;
    private boolean isInCommandLine = false;

    public Option(String shortName, String longName, String description, String defaultValue, boolean isMandatory, boolean needsExtra) {
        this(shortName, longName, description, defaultValue, isMandatory, needsExtra, "");
    }

    public Option(String shortName, String longName, String description, String defaultValue, boolean isMandatory, boolean needsExtra, String extraValueName) {
        this.shortName = shortName;
        this.longName = longName;
        this.description = description;
        this.currentValue = this.defaultValue = defaultValue;
        this.isMandatory = isMandatory;
        this.needsExtra = needsExtra;
        this.extraValueName = extraValueName;
        this.isInCommandLine = false;
        this.setUsage();
    }

    private void setUsage() {
        if (!this.shortName.isEmpty()) {
            this.usage = "-" + this.shortName + ", ";
            this.shortUsage = "-" + this.shortName;
        }
        this.usage = this.usage + "--" + this.longName;
        if (this.needsExtra && !this.extraValueName.isEmpty()) {
            this.usage = this.usage + " <" + this.extraValueName + ">";
            this.shortUsage = this.shortUsage + " <" + this.extraValueName + ">";
        }
    }

    public boolean checkExtraArg(String arg) {
        return !arg.startsWith("-");
    }

    public String getUsage() {
        return this.usage;
    }

    public String getShortUsage() {
        return this.shortUsage;
    }

    public void setShortUsage(String usage) {
        this.shortUsage = usage;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getLongName() {
        return this.longName;
    }

    public String getDescription() {
        if (this.description.contains("%s")) {
            this.description = String.format(this.description, this.getExtraValueName());
        }
        return this.description;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setCurrentValue(String value) {
        this.currentValue = value;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public boolean isMandatory() {
        return this.isMandatory;
    }

    public boolean isNeedsExtra() {
        return this.needsExtra;
    }

    public String getExtraValueName() {
        return this.extraValueName;
    }

    public void setInCommandLine(boolean isInCommandLine) {
        this.isInCommandLine = isInCommandLine;
    }

    public boolean isInCommandLine() {
        return this.isInCommandLine;
    }
}

