/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.helper;

import java.util.ArrayList;
import java.util.List;

public class ProcessResult {
    private Process process = null;
    boolean isStartedSuccessfully;
    int exitValue;
    List<String> stdOutMsg = new ArrayList<String>();
    List<String> stdErrMsg = new ArrayList<String>();

    ProcessResult(boolean isStartedSuccessfully, int exitValue) {
        this.isStartedSuccessfully = isStartedSuccessfully;
        this.exitValue = exitValue;
    }

    ProcessResult(Process process) {
        this.isStartedSuccessfully = true;
        this.process = process;
    }

    public Process getProcess() {
        return this.process;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public boolean isStartedSuccessfully() {
        return this.isStartedSuccessfully;
    }

    public boolean isSuccess() {
        return this.isStartedSuccessfully && this.exitValue == 0;
    }

    public List<String> getStdOutMsg() {
        return this.stdOutMsg;
    }

    public void setStdOutMsg(List<String> stdOutMsg) {
        this.stdOutMsg = stdOutMsg;
    }

    public List<String> getStdErrMsg() {
        return this.stdErrMsg;
    }

    public void setStdErrMsg(List<String> stdErrMsg) {
        this.stdErrMsg = stdErrMsg;
    }

    public String getResultMessage() {
        StringBuilder sb = new StringBuilder();
        for (String str : this.stdOutMsg) {
            sb.append(str).append("\n");
        }
        for (String str : this.stdErrMsg) {
            sb.append(str).append("\n");
        }
        return sb.toString();
    }
}

