/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.dialog;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Callable;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import javafx.util.Callback;
import org.tizen.emulator.manager.concurrent.SimpleExecutor;
import org.tizen.emulator.manager.concurrent.TaskCompletionListener;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.platform.Version;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.ui.dialog.ButtonType;
import org.tizen.emulator.manager.ui.dialog.Dialog;
import org.tizen.emulator.manager.ui.dialog.MessageBox;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.item.CheckBoxItem;
import org.tizen.emulator.manager.vms.helper.HelperClass;
import org.tizen.emulator.manager.vms.helper.ProcessOutputReader;
import org.tizen.emulator.manager.vms.helper.ProcessResult;

public class PlatformInstallDialog {
    private static Double WIDTH = 450.0;
    private static Double SCROLL_PANE_HEIGHT = 350.0;
    private Dialog<List<String>> dialog;
    private VBox root;
    private HBox titleBox;
    private Label title;
    private ScrollPane scrollPane;
    private AnchorPane anchorPane;
    private HBox retryBox;
    private VBox box;
    private Button okButton;
    private Button retryButton;
    private VBox platformListBox;
    private AnchorPane progressPane;
    private ProgressIndicator progress;
    private Label progressText;
    private Label retryText;
    private static int PROGRESS_SIZE = 70;
    static Dialog<ButtonType> closingDialog = null;
    static boolean dialogClosed;
    Process sdkUtilProcess = null;
    private static final URL VIEW_CSS;
    private List<CheckBoxItem> checkboxes = new ArrayList<CheckBoxItem>();
    private TaskCompletionListener<List<String>> platformListCompletionListener = new TaskCompletionListener<List<String>>(){

        @Override
        public void completed(final List<String> platformList) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (dialogClosed) {
                        EMLogger.getLogger().info("Inquiring platforms finished. But dialog already closed.");
                        return;
                    }
                    PlatformInstallDialog.this.progressPane.setVisible(false);
                    PlatformInstallDialog.this.retryButton.setDisable(false);
                    if (platformList == null || platformList.isEmpty()) {
                        PlatformInstallDialog.this.platformListBox.getChildren().add((Object)new Label("No platforms found from remote repository." + StringResources.NEW_LINE + "Please retry."));
                        return;
                    }
                    Collections.sort(platformList, new Comparator<String>(){

                        @Override
                        public int compare(String str1, String str2) {
                            String[] arr1 = str1.split("-");
                            String[] arr2 = str2.split("-");
                            if (arr1.length != 3 || arr2.length != 3) {
                                return 0;
                            }
                            Version ver1 = Version.createNew(arr1[1]);
                            Version ver2 = Version.createNew(arr2[1]);
                            int compare = ver2.compareTo(ver1);
                            if (compare != 0) {
                                return compare;
                            }
                            return arr1[0].compareTo(arr2[0]);
                        }
                    });
                    for (int i = 0; i < platformList.size(); ++i) {
                        CheckBoxItem checkBox = new CheckBoxItem();
                        checkBox.setText((String)platformList.get(i));
                        PlatformInstallDialog.this.platformListBox.getChildren().add((Object)checkBox.getContent());
                        checkBox.getContent().setPrefWidth(WIDTH - 50.0);
                        PlatformInstallDialog.this.checkboxes.add(checkBox);
                    }
                    for (CheckBoxItem item : PlatformInstallDialog.this.checkboxes) {
                        item.addEventHandler(EventType.Selection, new org.tizen.emulator.manager.ui.tabview.event.EventHandler<Event>(){

                            @Override
                            public void handleEvent(Event event) {
                                PlatformInstallDialog.this.setOKButtonState();
                            }
                        });
                    }
                    ((CheckBoxItem)PlatformInstallDialog.this.checkboxes.get(0)).setCheck(true);
                    PlatformInstallDialog.this.okButton.setDisable(false);
                    PlatformInstallDialog.this.okButton.requestFocus();
                }
            });
        }
    };
    private static TaskCompletionListener<Boolean> launchCompletionListener;

    public PlatformInstallDialog() {
        this.makeContent();
    }

    public static void processPlatformInstall(Window parent) {
        List<String> selectedPlatform = new PlatformInstallDialog().open(parent);
        if (selectedPlatform == null) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (String str : selectedPlatform) {
            sb.append(str).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        final String installPackageList = sb.toString();
        EMLogger.getLogger().info("Launch package manager..");
        SimpleExecutor.asynExecute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                String packageManagerBinary = OSUtil.isWin() ? "package-manager.exe" : "package-manager.bin";
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add(FilePathResources.getTizenSDKPackageManagerPath() + File.separator + packageManagerBinary);
                cmd.add("--automatic-installation");
                cmd.add(installPackageList);
                cmd.add("--caller-tool");
                cmd.add("emulator-manager");
                File workingDir = new File(FilePathResources.getTizenSDKPackageManagerPath());
                ProcessResult result = HelperClass.runProcess(cmd, workingDir, false);
                if (!result.isStartedSuccessfully()) {
                    final String resultMessage = result.getResultMessage();
                    EMLogger.getLogger().warning("Failed to launch the package-manager.");
                    EMLogger.getLogger().warning(resultMessage);
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MessageBox.error("Failed to launch the package-manager.\n" + resultMessage);
                        }
                    });
                    return false;
                }
                return true;
            }
        }, launchCompletionListener);
    }

    private void makeContent() {
        this.root = new VBox();
        this.root.getStylesheets().add((Object)VIEW_CSS.toExternalForm());
        this.titleBox = new HBox();
        this.titleBox.setPadding(new Insets(10.0));
        this.scrollPane = new ScrollPane();
        this.scrollPane.setPrefWidth(WIDTH.doubleValue());
        this.scrollPane.setPrefHeight(SCROLL_PANE_HEIGHT.doubleValue());
        this.scrollPane.setFitToWidth(true);
        this.root.getChildren().add((Object)this.titleBox);
        this.root.getChildren().add((Object)this.scrollPane);
        VBox.setVgrow((Node)this.scrollPane, (Priority)Priority.ALWAYS);
        this.title = new Label();
        this.title.setText("To create an emulator, you need to download platforms first.\nSelect the platform and press 'Ok'.\n\nNotice: Emulator manager will be closed and Package manager started.");
        this.titleBox.getChildren().add((Object)this.title);
        this.box = new VBox();
        this.box.setPadding(new Insets(10.0));
        this.anchorPane = new AnchorPane();
        this.anchorPane.getChildren().add((Object)this.box);
        this.scrollPane.setContent((Node)this.anchorPane);
        this.retryBox = new HBox();
        this.retryBox.setPadding(new Insets(0.0, 0.0, 10.0, 0.0));
        this.retryBox.setSpacing(10.0);
        this.retryBox.setAlignment(Pos.CENTER_LEFT);
        this.retryText = new Label("Installable platforms.");
        this.box.getChildren().add((Object)this.retryBox);
        this.retryBox.getChildren().add((Object)this.retryText);
        this.retryButton = new Button("Refresh List");
        this.retryButton.setTooltip(new Tooltip("Request platform list from repository server." + StringResources.NEW_LINE + "This may take a little seconds."));
        this.retryBox.getChildren().add((Object)this.retryButton);
        this.retryButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                PlatformInstallDialog.this.tryGettingPlatformList(false);
            }
        });
        this.platformListBox = new VBox();
        this.box.getChildren().add((Object)this.platformListBox);
        this.progressPane = new AnchorPane();
        this.anchorPane.getChildren().add((Object)this.progressPane);
        this.progressPane.setVisible(false);
        this.progress = new ProgressIndicator();
        this.progress.setOpacity(0.5);
        this.progress.setPrefSize((double)PROGRESS_SIZE, (double)PROGRESS_SIZE);
        this.progressPane.getChildren().add((Object)this.progress);
        this.progressText = new Label("Getting list from repository server ...");
        this.progressText.setPrefSize(WIDTH - 10.0, 20.0);
        this.progressText.setAlignment(Pos.CENTER);
        this.progressText.setStyle("-fx-text-fill:#888888");
        this.progressPane.getChildren().add((Object)this.progressText);
        this.scrollPane.layout();
        AnchorPane.setLeftAnchor((Node)this.progress, (Double)(this.scrollPane.getPrefWidth() / 2.0 - (double)(PROGRESS_SIZE / 2)));
        AnchorPane.setTopAnchor((Node)this.progress, (Double)(this.scrollPane.getPrefHeight() / 2.0 - (double)(PROGRESS_SIZE / 2)));
        AnchorPane.setLeftAnchor((Node)this.progressText, (Double)(this.scrollPane.getPrefWidth() / 2.0 - this.progressText.getPrefWidth() / 2.0));
        AnchorPane.setTopAnchor((Node)this.progressText, (Double)(this.scrollPane.getPrefHeight() / 2.0 - this.progressText.getPrefHeight() / 2.0));
    }

    private void tryGettingPlatformList(boolean useCache) {
        this.platformListBox.getChildren().remove(0, this.platformListBox.getChildren().size());
        this.checkboxes.clear();
        this.setOKButtonState();
        this.retryButton.setDisable(true);
        this.progressPane.setVisible(true);
        this.getPlatformListFromRemote(useCache);
    }

    public List<String> open(Window parent) {
        this.dialog = new Dialog();
        this.dialog.setTitle("Platform Installation");
        this.dialog.getDialogPane().setContent((Node)this.root);
        this.dialog.getDialogPane().addButonType(ButtonType.OK);
        this.dialog.getDialogPane().addButonType(ButtonType.CANCEL);
        this.dialog.setResultConverter(new Callback<ButtonType, List<String>>(){

            public List<String> call(ButtonType param) {
                ArrayList<String> result = new ArrayList<String>();
                if (param == ButtonType.CANCEL) {
                    return null;
                }
                for (CheckBoxItem item : PlatformInstallDialog.this.checkboxes) {
                    if (!item.isChecked()) continue;
                    result.add(item.toString());
                }
                return result;
            }
        });
        this.okButton = this.dialog.getDialogPane().getButton(ButtonType.OK);
        this.setOKButtonState();
        this.tryGettingPlatformList(true);
        this.root.layout();
        this.dialog.setX(parent.getX() + parent.getWidth() / 2.0 - WIDTH / 2.0);
        this.dialog.setY(parent.getY() + 80.0);
        dialogClosed = false;
        List<String> result = this.dialog.showAndWait();
        dialogClosed = true;
        if (this.sdkUtilProcess != null) {
            this.sdkUtilProcess.destroyForcibly();
        }
        return result;
    }

    private void getPlatformListFromRemote(final boolean useCache) {
        SimpleExecutor.asynExecute(new Callable<List<String>>(){

            @Override
            public List<String> call() throws Exception {
                ProcessResult result;
                String sdkUtil = OSUtil.isWin() ? "sdk-utils.bat" : "sdk-utils.sh";
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add(FilePathResources.getTizenSDKUtilPath() + File.separator + sdkUtil);
                cmd.add("show-packages");
                cmd.add("--pkg-type");
                cmd.add("meta-pkg");
                if (useCache) {
                    cmd.add("--cache");
                }
                if (!(result = HelperClass.runProcess(cmd, false)).isStartedSuccessfully()) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MessageBox.error("Failed to launch sdk-utils.\n" + result.getResultMessage());
                        }
                    });
                    EMLogger.getLogger().warning("Failed to launch sdk-utils.");
                    EMLogger.getLogger().warning(result.getResultMessage());
                    return null;
                }
                PlatformInstallDialog.this.sdkUtilProcess = result.getProcess();
                if (PlatformInstallDialog.this.sdkUtilProcess == null) {
                    return null;
                }
                List<String> stdOut = ProcessOutputReader.readStdOut(PlatformInstallDialog.this.sdkUtilProcess, ((Object)cmd).toString());
                int exitValue = PlatformInstallDialog.this.sdkUtilProcess.waitFor();
                PlatformInstallDialog.this.sdkUtilProcess = null;
                if (exitValue != 0 && !dialogClosed) {
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MessageBox.error("A sdk-utils has been terminated with error.\n" + result.getResultMessage());
                        }
                    });
                    EMLogger.getLogger().warning("A sdk-utils has been terminated with error.");
                    EMLogger.getLogger().warning(result.getResultMessage());
                    return null;
                }
                ArrayList<String> platformList = new ArrayList<String>();
                for (String str : stdOut) {
                    String[] arr = str.split("\\s+");
                    if (arr.length != 4 || !arr[0].equals("NI") || !arr[3].equals("Emulator")) continue;
                    platformList.add(arr[1]);
                }
                return platformList;
            }
        }, this.platformListCompletionListener);
    }

    private void setOKButtonState() {
        boolean okButtonDisable = true;
        for (CheckBoxItem item : this.checkboxes) {
            if (!item.isChecked()) continue;
            okButtonDisable = false;
            break;
        }
        this.okButton.setDisable(okButtonDisable);
    }

    static {
        VIEW_CSS = PlatformInstallDialog.class.getResource("/view/create/platformInstallDialogView.css");
        launchCompletionListener = new TaskCompletionListener<Boolean>(){

            @Override
            public void completed(Boolean launchSuccess) {
                EMLogger.getLogger().info("Package manager launched. Result : " + launchSuccess);
                if (!launchSuccess.booleanValue()) {
                    return;
                }
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        closingDialog = new Dialog();
                        closingDialog.setContentText("Starting the Package Manager ...");
                        closingDialog.setTitle("Emulator Manager");
                        closingDialog.show();
                    }
                });
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (closingDialog != null) {
                            closingDialog.setResult(ButtonType.OK);
                            closingDialog.close();
                            closingDialog = null;
                        }
                        System.exit(0);
                    }
                });
            }
        };
    }
}

