/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import java.util.Map;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.controller.ComboViewController;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.TemplateUtil;
import org.tizen.emulator.manager.ui.template.item.Item;
import org.tizen.emulator.manager.vms.property.GLVersionProperty;

public class GLVersionController
extends ComboViewController {
    private final EventHandler<ItemEvent> handler = new EventHandler<ItemEvent>(){

        @Override
        public void handleEvent(ItemEvent event) {
            if (event.newValue.equals(String.valueOf(false))) {
                GLVersionController.this.comboView.setEnable(false);
            } else {
                GLVersionController.this.comboView.setEnable(true);
            }
        }
    };
    private Map<String, String> optionMap;

    public GLVersionController(Item item) {
        super(item);
        ViewItemController.addChangeEventHandler("gpu", this.handler);
    }

    @Override
    public void setViewItem(ViewItem vItem) {
        super.setViewItem(vItem);
        this.optionMap = TemplateUtil.getOptionMap(this.item.getOptions());
        if (this.optionMap.get("v1.1_v2.0") != null) {
            this.comboView.addItem(this.optionMap.get("v1.1_v2.0"), "v1.1_v2.0");
        }
        if (this.optionMap.get("v2.0_v3.0") != null) {
            this.comboView.addItem(this.optionMap.get("v2.0_v3.0"), "v2.0_v3.0");
        }
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        if (this.comboView.getItemList().size() == 0) {
            return;
        }
        String text = value.getStringValue(this.getName());
        if (text == null || text.isEmpty()) {
            text = GLVersionProperty.getDefaultValue();
        }
        if (text != null && !text.isEmpty()) {
            if (text.equals("v1.1_v2.0")) {
                this.comboView.selectItem(this.optionMap.get("v1.1_v2.0"));
            } else if (text.equals("v2.0_v3.0")) {
                this.comboView.selectItem(this.optionMap.get("v2.0_v3.0"));
            } else {
                this.comboView.selectItem(0);
            }
        } else {
            this.comboView.selectItem(0);
        }
        if (!value.getBooleanValue("gpu").booleanValue()) {
            this.comboView.setEnable(false);
        }
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        if (this.comboView.isEnabled() && this.comboView.getSelectedData() != null) {
            value.setStringValue(this.getName(), this.comboView.getSelectedData().toString());
        } else {
            value.setStringValue(this.getName(), "");
        }
    }

    @Override
    public void dispose() {
        ViewItemController.removeChangeEventHandler("deviceTemplate", this.handler);
    }
}

