/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.template;

import java.util.ArrayList;
import java.util.List;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.ui.template.item.Group;
import org.tizen.emulator.manager.ui.template.item.Item;
import org.tizen.emulator.manager.vms.xml.template.ItemList;

public class Template
implements Cloneable {
    private String filePath = "";
    private String templateVersion = "";
    private String profile = "";
    private String platformVersion = "";
    private String imageName = "";
    private List<Group> groups = new ArrayList<Group>();
    @Deprecated
    private ItemList oldVersionItemList;

    public String getTemplateVersion() {
        return this.templateVersion;
    }

    public void setTemplateVersion(String version) {
        this.templateVersion = version;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public void setPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public List<Group> getGroups() {
        return this.groups;
    }

    public void setGroups(List<Group> itemGroups) {
        this.groups = itemGroups;
    }

    public void addGroup(Group group) {
        this.groups.add(group);
    }

    public String toString() {
        String newLine = StringResources.NEW_LINE;
        String str = "[Template] ver: " + this.templateVersion + ", profile: " + this.profile + ", platform-ver: " + this.platformVersion + ", image: " + this.imageName + newLine;
        for (Group group : this.getGroups()) {
            str = str + group.toString();
        }
        return str;
    }

    @Deprecated
    public void setVersion1ItemList(ItemList itemList) {
        this.oldVersionItemList = itemList;
    }

    @Deprecated
    public ItemList getVersion1ItemList() {
        return this.oldVersionItemList;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public Group findGroup(String groupName) {
        for (Group group : this.groups) {
            if (!group.getName().equals(groupName)) continue;
            return group;
        }
        return null;
    }

    public Item findItem(String groupName, String itemName) {
        Group group = this.findGroup(groupName);
        if (group == null) {
            return null;
        }
        for (Item item : group.getItems()) {
            if (!item.getName().equals(itemName)) continue;
            return item;
        }
        return null;
    }

    public Template clone() {
        Template result = new Template();
        result.filePath = this.filePath;
        result.templateVersion = this.templateVersion;
        result.profile = this.profile;
        result.platformVersion = this.platformVersion;
        result.imageName = this.imageName;
        for (Group group : this.groups) {
            result.groups.add(group.clone());
        }
        return result;
    }
}

