/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.monitor;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import org.tizen.emulator.manager.EmulatorManager;
import org.tizen.emulator.manager.vms.ManagedVMKeeper;
import org.tizen.emulator.manager.vms.monitor.FileAssetsMonitor;
import org.tizen.emulator.manager.vms.monitor.FileWatcher;
import org.tizen.emulator.manager.vms.monitor.MonitoringThread;

class VMPropertyMonitor
extends FileAssetsMonitor {
    private final PathMatcher matcher;
    private final ManagedVMKeeper keeper = (ManagedVMKeeper)EmulatorManager.getVMKeeper();

    VMPropertyMonitor() throws IOException {
        this.matcher = FileSystems.getDefault().getPathMatcher("glob:**/vm_config.xml");
        FileWatcher.addListener(this);
    }

    private boolean isMonitoringFile(Path path) {
        return this.matcher.matches(path);
    }

    private void preexistingDirectoryFound(final Path dir) {
        MonitoringThread.newMonitoringThread(new Runnable(){

            @Override
            public void run() {
                try {
                    DirectoryStream<Path> stream = Files.newDirectoryStream(dir, "vm_config.xml");
                    for (Path path : stream) {
                        if (!Files.isRegularFile(path, new LinkOption[0]) || !Files.isReadable(path)) continue;
                        VMPropertyMonitor.this.keeper.addVM(path);
                    }
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }, "Preparing pre-existing VMs in [" + dir.getFileName() + "]").start();
    }

    @Override
    public void preexistingDirectoryFound(Path[] dirs) {
        for (Path dir : dirs) {
            this.preexistingDirectoryFound(dir);
        }
    }

    @Override
    public void fileCreated(Path path) {
        if (this.isMonitoringFile(path)) {
            this.keeper.addVM(path);
        }
    }

    @Override
    public void fileModified(Path path) {
        if (this.isMonitoringFile(path)) {
            this.keeper.refreshVM(path);
        }
    }

    @Override
    public void fileDeleted(Path path) {
        if (this.isMonitoringFile(path)) {
            this.keeper.removeVM(path);
        }
    }

    @Override
    public void directoryCreated(Path path) {
        this.preexistingDirectoryFound(path);
    }

    @Override
    public void directoryModified(Path path) {
    }

    @Override
    public void directoryDeleted(Path path) {
        this.keeper.removeVM(path.resolve("vm_config.xml"));
    }
}

