/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.create;

import java.io.IOException;
import java.net.URL;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.ui.controller.create.DeviceTemplateListController;
import org.tizen.emulator.manager.ui.controller.create.VMDialogData;
import org.tizen.emulator.manager.ui.controller.create.VMDialogPage;
import org.tizen.emulator.manager.ui.dialog.ButtonType;
import org.tizen.emulator.manager.ui.tabview.TabViewer;

public class DeviceTemplateListPage
implements VMDialogPage {
    private static DeviceTemplateListController controller = null;
    private static final URL TEMPLATE_LIST_CSS = DeviceTemplateListController.class.getResource("/view/create/deviceTemplateListView.css");

    public DeviceTemplateListPage() {
        this.initController();
    }

    private void initController() {
        FXMLLoader loader = new FXMLLoader(TabViewer.class.getResource("/view/create/deviceTemplateListView.fxml"));
        try {
            loader.load();
            controller = (DeviceTemplateListController)loader.getController();
        }
        catch (IOException e) {
            e.printStackTrace();
            EMLogger.getLogger().warning(e.getMessage());
        }
        controller.getRootPane().getStylesheets().add((Object)TEMPLATE_LIST_CSS.toExternalForm());
    }

    @Override
    public void onPageShow(VMDialogData vmDialogData, SimpleBooleanProperty isInvalid) {
        controller.makeDataList(vmDialogData.getPlatform());
        controller.selectDefaultData(vmDialogData.getDeviceTemplate());
        controller.setVMDialogData(vmDialogData);
        controller.setNextButton(vmDialogData.getButtons().getButton(ButtonType.NEXT));
    }

    @Override
    public void setData(VMDialogData vmDialogData) {
        vmDialogData.setDeviceTemplate(controller.getDeviceTemplate());
    }

    @Override
    public Node getNode() {
        return controller.getRootPane();
    }

    @Override
    public String getTitle() {
        return "Template";
    }

    @Override
    public String getDescription() {
        return "Select the device definition";
    }
}

