/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.create;

import java.io.IOException;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.ui.Main;
import org.tizen.emulator.manager.ui.controller.ButtonBarController;
import org.tizen.emulator.manager.ui.controller.create.PlatformPropertyView;
import org.tizen.emulator.manager.ui.controller.create.PropertyViewController;
import org.tizen.emulator.manager.ui.dialog.ButtonType;
import org.tizen.emulator.manager.ui.tabview.MODE;

public abstract class PropertyView {
    private Stage stage;
    protected PropertyViewController controller;
    protected static final int ITEM_HEIGHT = 24;
    private final MODE mode;
    ButtonBarController buttons;
    protected SimpleBooleanProperty isInvalid = new SimpleBooleanProperty();

    public PropertyView(MODE mode) {
        this.initController();
        this.mode = mode;
        this.createButtons();
        this.isInvalid.addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                Button button = PropertyView.this.buttons.getButton(ButtonType.OK);
                if (button != null) {
                    button.setDisable(arg2.booleanValue());
                }
            }
        });
        this.isInvalid.set(false);
    }

    private void initController() {
        FXMLLoader loader = new FXMLLoader(PlatformPropertyView.class.getResource("/view/create/propertyView.fxml"));
        try {
            loader.load();
            this.controller = (PropertyViewController)loader.getController();
        }
        catch (IOException e) {
            e.printStackTrace();
            EMLogger.getLogger().warning(e.getMessage());
        }
    }

    private void createButtons() {
        if (this.buttons != null) {
            return;
        }
        this.buttons = new ButtonBarController(86, 24);
        this.controller.getRoot().setBottom((Node)this.buttons.makeButtonBox(60));
        this.buttons.addButton(ButtonType.CANCEL);
        this.buttons.addButton(ButtonType.OK);
    }

    public void attachToAnchorPane(AnchorPane anchor) {
        if (anchor == null) {
            return;
        }
        BorderPane root = this.controller.getRoot();
        anchor.getChildren().add((Object)root);
        AnchorPane.setBottomAnchor((Node)root, (Double)0.0);
        AnchorPane.setTopAnchor((Node)root, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)root, (Double)0.0);
        AnchorPane.setRightAnchor((Node)root, (Double)0.0);
    }

    public BorderPane getRootBorderPane() {
        return this.controller.getRoot();
    }

    public MODE getMode() {
        return this.mode;
    }

    public ButtonBarController getButtons() {
        return this.buttons;
    }

    public void setConfirmButtonClicked(EventHandler<ActionEvent> handler) {
        Button btn = this.buttons.getButton(ButtonType.OK);
        assert (btn != null);
        btn.setOnAction(handler);
    }

    public void setCancelButtonClicked(EventHandler<ActionEvent> handler) {
        Button btn = this.buttons.getButton(ButtonType.CANCEL);
        assert (btn != null);
        btn.setOnAction(handler);
    }

    public void openPropertyView(Window owner, String title, int width, int height) {
        this.stage = new Stage();
        Scene scene = new Scene((Parent)this.controller.getRoot());
        scene.getStylesheets().addAll(Main.getBaseCssUrl());
        this.stage.setTitle(title);
        this.stage.setScene(scene);
        this.stage.initModality(Modality.APPLICATION_MODAL);
        this.setOwner(owner);
        this.stage.setWidth((double)width);
        this.stage.setHeight((double)height);
        this.stage.show();
    }

    public void closePropertyView() {
        this.stage.close();
    }

    public void setOnClosed(EventHandler<WindowEvent> handler) {
        this.stage.setOnHidden(handler);
    }

    private void setOwner(Window owner) {
        if (owner instanceof Stage) {
            Stage newStage = (Stage)owner;
            Bindings.bindContent((List)this.stage.getIcons(), (ObservableList)newStage.getIcons());
        }
        this.stage.initOwner(owner);
    }
}

