/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.vms;

import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.util.Callback;
import org.tizen.emulator.manager.ui.controller.vms.ROW_STATE;
import org.tizen.emulator.manager.ui.item.PlatformDisplayData;
import org.tizen.emulator.manager.ui.item.VMItem;

class VMDeviceCell
extends TableCell<VMItem, String> {
    private SimpleObjectProperty<ROW_STATE> prop;
    private ImageView icon;
    private ImageView selectedIcon;
    private ImageView overIcon;
    private ImageView tooltipIcon;
    private ChangeListener<ROW_STATE> listener = new ChangeListener<ROW_STATE>(){

        public void changed(ObservableValue<? extends ROW_STATE> arg, ROW_STATE oldValue, ROW_STATE newValue) {
            VMDeviceCell.this.setIcon(newValue);
        }
    };

    VMDeviceCell() {
    }

    protected void updateItem(String item, boolean empty) {
        super.updateItem((Object)item, empty);
        if (empty) {
            this.setText(null);
            this.setGraphic(null);
            this.setTooltip(null);
            if (this.prop != null) {
                this.prop.removeListener(this.listener);
            }
            return;
        }
        VMItem vmItem = (VMItem)this.getTableRow().getItem();
        if (item == null || vmItem == null) {
            return;
        }
        this.setText(item);
        if (vmItem.getData() == null) {
            this.setText(null);
            this.setGraphic(null);
            this.setTooltip(null);
            if (this.prop != null) {
                this.prop.removeListener(this.listener);
            }
            return;
        }
        PlatformDisplayData data = vmItem.getData();
        this.icon = new ImageView(data.getIcon());
        this.selectedIcon = new ImageView(data.getSelectedIcon());
        this.overIcon = new ImageView(data.getOverIcon());
        this.tooltipIcon = new ImageView(data.getTooltipIcon());
        if (this.prop != null) {
            this.prop.removeListener(this.listener);
        }
        this.prop = vmItem.getRowState();
        this.prop.addListener(this.listener);
        this.setIcon((ROW_STATE)((Object)this.prop.get()));
        Tooltip tooltip = new Tooltip();
        tooltip.setGraphic((Node)this.tooltipIcon);
        this.setTooltip(tooltip);
    }

    private void setIcon(ROW_STATE state) {
        switch (state) {
            case NORMAL: {
                this.setGraphic((Node)this.icon);
                break;
            }
            case OVER: {
                this.setGraphic((Node)this.overIcon);
                break;
            }
            case SELECTED: {
                this.setGraphic((Node)this.selectedIcon);
                break;
            }
            default: {
                this.setGraphic(null);
            }
        }
    }

    static Callback<TableColumn<VMItem, String>, TableCell<VMItem, String>> extractor() {
        return new Callback<TableColumn<VMItem, String>, TableCell<VMItem, String>>(){

            public TableCell<VMItem, String> call(TableColumn<VMItem, String> param) {
                VMDeviceCell cell = new VMDeviceCell();
                cell.getStyleClass().add((Object)"device-cell");
                return cell;
            }
        };
    }
}

