/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.concurrent.overseer;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import org.tizen.emulator.manager.concurrent.SimpleExecutor;
import org.tizen.emulator.manager.concurrent.overseer.Job;
import org.tizen.emulator.manager.concurrent.overseer.JobCallable;
import org.tizen.emulator.manager.logging.EMLogger;

public class Overseer {
    private static final List<Overseer> overseers = new ArrayList<Overseer>();
    private final List<Class<? extends Job>> jobClasses = new ArrayList<Class<? extends Job>>();
    private Thread overseerThread;
    private CountDownLatch doneSignal;
    private String name;

    private Overseer() {
    }

    public static Overseer lookupOverseer(String name) {
        for (Overseer overseer : overseers) {
            if (!overseer.name.equals(name)) continue;
            return overseer;
        }
        return null;
    }

    public void registerJob(Class<? extends Job> jobCls) {
        this.jobClasses.add(jobCls);
    }

    @SafeVarargs
    public static Overseer newOverseer(String name, Class<? extends Job> ... jobClasses) {
        Overseer overseer = new Overseer();
        overseer.name = name;
        for (Class<? extends Job> jobCls : jobClasses) {
            overseer.registerJob(jobCls);
        }
        overseers.add(overseer);
        return overseer;
    }

    public void startWork() throws InterruptedException {
        if (this.overseerThread != null) {
            assert (false) : "Overseer [" + this.name + "] already started !!!";
            return;
        }
        EMLogger.getLogger().log(Level.INFO, "Overseer [" + this.name + "] is starting...");
        this.doneSignal = new CountDownLatch(this.jobClasses.size());
        for (Class<? extends Job> jobCls : this.jobClasses) {
            SimpleExecutor.asynExecute(new JobCallable(this.doneSignal, jobCls));
        }
        this.overseerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Overseer.this.doneSignal.await();
                    EMLogger.getLogger().log(Level.INFO, "Overseer [" + Overseer.this.name + "] is done...");
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
        this.overseerThread.start();
    }

    public void join() throws InterruptedException {
        if (this.overseerThread == null) {
            return;
        }
        if (this.overseerThread.isAlive()) {
            this.overseerThread.join();
            return;
        }
    }
}

