/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.devices;

import java.util.ArrayList;
import java.util.List;
import org.tizen.emulator.manager.devices.DeviceTemplate;
import org.tizen.emulator.manager.devices.DeviceTemplatePriority;
import org.tizen.emulator.manager.devices.DeviceTemplateType;
import org.tizen.emulator.manager.devices.SubDevice;
import org.tizen.emulator.manager.devices.SubDeviceItem;
import org.tizen.emulator.manager.devices.SubDeviceValue;
import org.tizen.emulator.manager.platform.Skin;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.vms.type.RESOLUTION;
import org.tizen.emulator.manager.vms.type.SKIN_SHAPE;

public class DeviceTemplateValue {
    private DeviceTemplate template;
    private boolean isStandard = false;
    private boolean isPlatformExtension = false;
    private String name = "";
    private DeviceTemplateType type = DeviceTemplateType.CUSTOM;
    private String profile = "";
    private String extenstion = "";
    private DeviceTemplatePriority priority = DeviceTemplatePriority.CUSTOM;
    private double version = 1.0;
    private String manufacturer = "";
    private RESOLUTION resolution;
    private int displayWidth = 0;
    private int displayHeight = 0;
    private String displaySizeUnit = "inch";
    private double displaySize = 0.0;
    private int displayDPI = 0;
    private String skinName = "";
    private String skinPath = "";
    private SKIN_SHAPE skinShape = SKIN_SHAPE.SQUARE;
    private Skin skin;
    private Skin vmSkin;
    private String ramSizeUnit = "MB";
    private int ramSize = 512;
    private int cpuCount = 1;
    private List<SubDevice> additionalDevices = new ArrayList<SubDevice>();

    public String getPrintValue() {
        StringBuilder sb = new StringBuilder();
        sb.append("name : " + this.name + StringResources.NEW_LINE);
        sb.append("profile : " + this.profile + StringResources.NEW_LINE);
        if (this.resolution != null) {
            sb.append("resolution : " + this.resolution.toString() + StringResources.NEW_LINE);
        }
        sb.append("width : " + this.displayWidth + StringResources.NEW_LINE);
        sb.append("height : " + this.displayHeight + StringResources.NEW_LINE);
        if (this.skin != null) {
            sb.append("skin: " + this.skin.getName() + StringResources.NEW_LINE);
        }
        sb.append("skin shape : " + this.skinShape.toString() + StringResources.NEW_LINE);
        sb.append("size : " + this.displaySize + StringResources.NEW_LINE);
        sb.append("ram : " + this.ramSize + StringResources.NEW_LINE);
        sb.append("processor : " + this.cpuCount + StringResources.NEW_LINE);
        sb.append(StringResources.NEW_LINE);
        sb.append("======= sub devices ========");
        sb.append(StringResources.NEW_LINE);
        for (SubDevice subDev : this.additionalDevices) {
            sb.append("  " + subDev.getName() + " : ");
            for (SubDeviceItem item : subDev.getItems()) {
                sb.append(item.getId() + "(" + item.isSupport() + ")" + ", ");
            }
            sb.append(StringResources.NEW_LINE);
        }
        return sb.toString();
    }

    public DeviceTemplateValue(DeviceTemplate template) {
        this.template = template;
    }

    public DeviceTemplateValue(DeviceTemplateValue value) {
        this.template = value.template;
        if (this.template.getConf() != null) {
            this.template.settingDeviceTemplateValue(this);
        } else {
            this.copyValue(value);
        }
    }

    private void copyValue(DeviceTemplateValue value) {
        this.profile = value.profile;
        this.cpuCount = value.cpuCount;
        this.displayDPI = value.displayDPI;
        this.displayHeight = value.displayHeight;
        this.displaySize = value.displaySize;
        this.displayWidth = value.displayWidth;
        this.extenstion = value.extenstion;
        this.isStandard = value.isStandard;
        this.manufacturer = value.manufacturer;
        this.name = value.name;
        this.priority = value.priority;
        this.ramSize = value.ramSize;
        this.skinName = value.skinName;
        this.skinPath = value.skinPath;
        this.skinShape = value.skinShape;
        this.type = value.type;
        this.version = value.version;
        this.isPlatformExtension = value.isPlatformExtension;
        for (SubDevice subDev : value.additionalDevices) {
            this.additionalDevices.add(new SubDevice(subDev));
        }
        if (this.resolution != null) {
            // empty if block
        }
        if (this.skin != null) {
            // empty if block
        }
    }

    public static DeviceTemplateValue createDefaultValue(String profile) {
        DeviceTemplateValue value = new DeviceTemplate().getValue();
        value.setProfile(profile);
        value.setDisplaySize(5.0);
        return value;
    }

    private int calculatorDPI() {
        return (int)Math.round(Math.hypot(this.displayWidth, this.displayHeight) / this.displaySize);
    }

    public DeviceTemplate getTemplate() {
        return this.template;
    }

    public boolean isStandard() {
        return this.isStandard;
    }

    public void setTemplate(DeviceTemplate template) {
        this.template = template;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DeviceTemplateType getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type.equals(DeviceTemplateType.STANDARD.getType())) {
            this.type = DeviceTemplateType.STANDARD;
            this.isStandard = true;
        } else {
            this.type = DeviceTemplateType.CUSTOM;
            this.isStandard = false;
        }
    }

    public void setType(DeviceTemplateType type) {
        this.type = type;
        this.isStandard = type == DeviceTemplateType.STANDARD;
    }

    public String getExtenstion() {
        return this.extenstion;
    }

    public void setExtenstion(String extenstion) {
        this.extenstion = extenstion;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public DeviceTemplatePriority getPriority() {
        return this.priority;
    }

    public void setPriority(DeviceTemplatePriority priority) {
        this.priority = priority;
    }

    public double getVersion() {
        return this.version;
    }

    public void setVersion(double version) {
        this.version = version;
    }

    public void updateVersion() {
        double ver = this.version + 0.1;
        this.version = Double.parseDouble(String.format("%.1f", ver));
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    public RESOLUTION getResolution() {
        return this.resolution;
    }

    public void setResolution(RESOLUTION resolution) {
        this.resolution = resolution;
        this.displayWidth = resolution.getWidth();
        this.displayHeight = resolution.getHeight();
        this.displayDPI = this.calculatorDPI();
    }

    public int getDisplayWidth() {
        return this.displayWidth;
    }

    public void setDisplayWidth(int displayWidth) {
        this.displayWidth = displayWidth;
        this.displayDPI = this.calculatorDPI();
    }

    public int getDisplayHeight() {
        return this.displayHeight;
    }

    public void setDisplayHeight(int displayHeight) {
        this.displayHeight = displayHeight;
        this.displayDPI = this.calculatorDPI();
    }

    public double getDisplaySize() {
        return this.displaySize;
    }

    public void setDisplaySize(double displaySize) {
        this.displaySize = displaySize;
        this.displayDPI = this.calculatorDPI();
    }

    public String getDisplaySizeUnit() {
        return this.displaySizeUnit;
    }

    public void setDisplaySizeUnit(String displaySizeUnit) {
        this.displaySizeUnit = displaySizeUnit;
    }

    public int getDisplayDPI() {
        return this.displayDPI;
    }

    public void setDisplayDPI(int displayDPI) {
        this.displayDPI = displayDPI;
    }

    public String getSkinName() {
        return this.skinName;
    }

    public void setSkinName(String skinName) {
        this.skinName = skinName;
    }

    public String getSkinPath() {
        return this.skinPath;
    }

    public void setSkinPath(String skinPath) {
        this.skinPath = skinPath;
    }

    public SKIN_SHAPE getSkinShape() {
        return this.skinShape;
    }

    public void setSkinShape(SKIN_SHAPE skinShape) {
        this.skinShape = skinShape;
    }

    public Skin getSkin() {
        return this.skin;
    }

    public void setSkin(Skin skin) {
        this.skin = skin;
        this.skinName = skin.getName();
        this.skinPath = skin.getPath();
    }

    public void setSkinByManager(Skin skin) {
        this.vmSkin = skin;
    }

    public Skin getSkinByManager() {
        return this.vmSkin;
    }

    public int getRamSize() {
        return this.ramSize;
    }

    public void setRamSize(int ramSize) {
        this.ramSize = ramSize;
    }

    public String getRamSizeUnit() {
        return this.ramSizeUnit;
    }

    public void setRamSizeUnit(String ramSizeUnit) {
        this.ramSizeUnit = ramSizeUnit;
    }

    public int getCpuCount() {
        return this.cpuCount;
    }

    public void setCpuCount(int cpuCount) {
        this.cpuCount = cpuCount;
    }

    public boolean isPlatformExtension() {
        return this.isPlatformExtension;
    }

    public void setPlatformExtension(boolean isPlatformExtension) {
        this.isPlatformExtension = isPlatformExtension;
    }

    public List<SubDevice> getAdditionalDevices() {
        return this.additionalDevices;
    }

    public void setAdditionalDevices(List<SubDevice> additionalDevices) {
        this.additionalDevices = additionalDevices;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DeviceTemplateValue)) {
            return false;
        }
        DeviceTemplateValue dest = (DeviceTemplateValue)obj;
        if (this.resolution == null) {
            if (dest.resolution != null) {
                return false;
            }
        } else {
            if (dest.resolution == null) {
                return false;
            }
            if (this.resolution.equals(dest.resolution)) {
                // empty if block
            }
        }
        if (this.displayDPI != dest.displayDPI) {
            return false;
        }
        if (this.displayHeight != dest.displayHeight) {
            return false;
        }
        if (this.displayWidth != dest.displayWidth) {
            return false;
        }
        if (this.displaySize != dest.displaySize) {
            return false;
        }
        if (this.skinPath == null) {
            if (dest.skinPath != null) {
                return false;
            }
        } else {
            if (dest.skinPath == null) {
                return false;
            }
            if (!this.skinPath.equals(dest.skinPath)) {
                return false;
            }
        }
        if (this.ramSize != dest.ramSize) {
            return false;
        }
        if (this.cpuCount != dest.cpuCount) {
            return false;
        }
        if (this.skinShape != dest.skinShape) {
            return false;
        }
        if (this.isPlatformExtension != dest.isPlatformExtension) {
            return false;
        }
        return this.isAdditionalDeviceEquals(dest.getAdditionalDevices());
    }

    private SubDevice findSubDevice(String name) {
        for (SubDevice sub : this.additionalDevices) {
            if (!sub.getName().equals(name)) continue;
            return sub;
        }
        return null;
    }

    public void updateSubDevice(String name, String itemName, boolean isSupport) {
        SubDevice subDevice = this.findSubDevice(name);
        if (subDevice == null) {
            subDevice = new SubDevice(name);
            subDevice.updateSubDeviceItem(itemName, isSupport);
            this.additionalDevices.add(subDevice);
        } else {
            subDevice.updateSubDeviceItem(itemName, isSupport);
        }
    }

    public void updateSubDevice(String name, String itemName, String value) {
        SubDevice subDevice = this.findSubDevice(name);
        if (subDevice == null) {
            subDevice = new SubDevice(name);
            subDevice.updateSubDeviceValue(itemName, value);
            this.additionalDevices.add(subDevice);
        } else {
            subDevice.updateSubDeviceValue(itemName, value);
        }
    }

    public boolean getSubItemSupport(String deviceName, String itemId) {
        SubDevice subDevice = this.findSubDevice(deviceName);
        if (subDevice == null) {
            return true;
        }
        SubDeviceItem deviceItem = this.findSubDeviceItem(subDevice, itemId);
        if (deviceItem == null) {
            return true;
        }
        return deviceItem.isSupport();
    }

    public String getSubDeviceValue(String deviceName, String valueName) {
        String result = "";
        SubDevice subDevice = this.findSubDevice(deviceName);
        if (subDevice == null) {
            return result;
        }
        SubDeviceValue value = this.findSubDeviceValue(subDevice, valueName);
        if (value == null) {
            return result;
        }
        return value.getValue();
    }

    private SubDeviceValue findSubDeviceValue(SubDevice subDevice, String valueName) {
        for (SubDeviceValue value : subDevice.getValues()) {
            if (!value.getName().equals(valueName)) continue;
            return value;
        }
        return null;
    }

    private SubDeviceItem findSubDeviceItem(SubDevice subDevice, String itemId) {
        for (SubDeviceItem item : subDevice.getItems()) {
            if (!item.getId().equals(itemId)) continue;
            return item;
        }
        return null;
    }

    public boolean isAdditionalDeviceEquals(List<SubDevice> destList) {
        if (this.additionalDevices == null && destList == null) {
            return true;
        }
        if (this.additionalDevices == null || destList == null) {
            return false;
        }
        if (this.additionalDevices.size() != destList.size()) {
            return false;
        }
        for (SubDevice device : this.additionalDevices) {
            boolean equals = false;
            for (SubDevice destDevice : destList) {
                if (!device.equals(destDevice)) continue;
                equals = true;
                break;
            }
            if (equals) continue;
            return false;
        }
        return true;
    }

    public boolean isRearCameraSupport() {
        SubDevice camera = this.findSubDevice("camera");
        if (camera == null) {
            return false;
        }
        SubDeviceItem rearCameraItem = this.findSubDeviceItem(camera, "rear");
        if (rearCameraItem == null) {
            return false;
        }
        return rearCameraItem.isSupport();
    }
}

