/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.network;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.exception.VMWorkerException;
import org.tizen.emulator.manager.vms.helper.HelperClass;
import org.tizen.emulator.manager.vms.helper.ProcessResult;

public class NetworkProxy {
    public static String hostProxy;

    public static String getManualProxy(VMProperty property) {
        return "http_proxy=" + property.getPropertyValue().getAdvancedSubOptionValue("proxy", "httpProxy") + " https_proxy=" + property.getPropertyValue().getAdvancedSubOptionValue("proxy", "httpsProxy") + " ftp_proxy=" + property.getPropertyValue().getAdvancedSubOptionValue("proxy", "ftpProxy") + " socks_proxy=" + property.getPropertyValue().getAdvancedSubOptionValue("proxy", "socksProxy");
    }

    public static String getHostProxy() throws VMWorkerException {
        if (hostProxy != null) {
            return hostProxy;
        }
        String result = null;
        String proxyCommand = "check-net";
        if (OSUtil.isWin()) {
            proxyCommand = "check-net.exe";
        }
        List<String> cmd = Arrays.asList(FilePathResources.getEmulatorCheckToolPath() + File.separator + proxyCommand, "--proxy");
        File workingDir = new File(FilePathResources.getToolEmulatorBinPath());
        ProcessResult res = HelperClass.runProcess(cmd, workingDir);
        EMLogger.getLogger().info("check-net result : " + res.getResultMessage());
        boolean isCommandSuccess = false;
        if (res.isSuccess()) {
            for (String str : res.getStdOutMsg()) {
                if (str.startsWith("MODE:")) {
                    isCommandSuccess = true;
                }
                if (!str.startsWith("http_proxy")) continue;
                result = str;
            }
        } else if (!res.isSuccess() || !isCommandSuccess) {
            EMLogger.getLogger().warning("Failed to get host proxy setting.");
            throw new VMWorkerException("Failed to get host proxy setting.");
        }
        if (result == null) {
            EMLogger.getLogger().warning("Can't find host proxy setting.");
            result = "";
        }
        hostProxy = result;
        return hostProxy;
    }
}

