/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms;

import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import javax.xml.bind.JAXBException;
import org.tizen.emulator.manager.EmulatorManager;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.platform.PlatformStringResources;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.vms.ListChangeListener;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.VMPropertyValue;

public abstract class VMKeeper {
    private static VMKeeper instance = null;
    private static final List<ListChangeListener<VMProperty>> listChangelisteners = Collections.synchronizedList(new ArrayList());

    protected VMKeeper() throws JAXBException {
        if (instance != null) {
            // empty if block
        }
        instance = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addListChangeListener(ListChangeListener<VMProperty> listener) {
        listChangelisteners.add(listener);
        if (instance == null) {
            return;
        }
        List<ListChangeListener<VMProperty>> list = listChangelisteners;
        synchronized (list) {
            for (VMProperty property : instance.getProperties()) {
                listener.elementAdded(property);
            }
        }
    }

    public static void removeListChangeListener(ListChangeListener<VMProperty> listener) {
        listChangelisteners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void listChanged(VMProperty property, ChangeType change) {
        List<ListChangeListener<VMProperty>> list = listChangelisteners;
        synchronized (list) {
            block8: for (ListChangeListener<VMProperty> listener : listChangelisteners) {
                switch (change) {
                    case ADDED: {
                        listener.elementAdded(property);
                        continue block8;
                    }
                    case REMOVED: {
                        listener.elementRemoved(property);
                        continue block8;
                    }
                    case MODIFIED: {
                        listener.elementModified(property);
                        continue block8;
                    }
                }
                assert (false);
            }
        }
    }

    public abstract void initialize();

    public abstract VMProperty getProperty(String var1);

    public abstract Queue<VMProperty> getProperties();

    public VMProperty createProperty(VMPropertyValue value) {
        return VMProperty.createNew(value);
    }

    public VMProperty modifyProperty(VMProperty property, VMPropertyValue value) {
        return property.modify(value);
    }

    public VMProperty loadProperty(Path propertyFile) {
        return VMProperty.loadFrom(propertyFile);
    }

    public static VMProperty loadProperty(String imageName, Platform platform) {
        File templateDir = new File(platform.getPlatformPath() + File.separator + FilePathResources.getPlatformTemplateSuffix());
        File templateFile = null;
        File standardFile = null;
        File[] fileList = templateDir.listFiles();
        if (fileList != null) {
            for (File f : fileList) {
                if (!f.getName().endsWith(".xml") || f.getName().contains(PlatformStringResources.TEMPLATE)) continue;
                if (f.getName().contains(imageName)) {
                    templateFile = f;
                    break;
                }
                if (!f.getName().contains(PlatformStringResources.STANDARD)) continue;
                standardFile = f;
            }
        }
        if (templateFile == null && standardFile == null) {
            return null;
        }
        if (templateFile == null && standardFile != null) {
            templateFile = standardFile;
        }
        VMProperty defaultProperty = EmulatorManager.getVMKeeper().loadProperty(templateFile.toPath());
        return defaultProperty;
    }

    public static enum ChangeType {
        ADDED,
        REMOVED,
        MODIFIED;

    }
}

