/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.option;

import java.io.File;
import org.tizen.emulator.manager.Messages;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.exception.VMLauncherException;
import org.tizen.emulator.manager.vms.option.LaunchConfig;
import org.tizen.emulator.manager.vms.option.OPTION_KEY;
import org.tizen.emulator.manager.vms.option.Option;

public class FileShareOption
extends Option {
    @Override
    public void getLaunchArgument(LaunchConfig config, VMProperty property) {
        String fileshare = property.getPropertyValue().fileSharePath;
        if (fileshare != null && property.getPropertyValue().isFileShareSupport) {
            config.addVariableWithSpace(OPTION_KEY.VAR_SHARING_PATH, fileshare);
            config.addKernelOption("virtio-9p");
            config.addQemuOption("-fsdev", "local,id=fsdef0,path=" + FileShareOption.varForm(OPTION_KEY.VAR_SHARING_PATH) + ",security_model=none");
            config.addQemuOption("-device", "virtio-9p-pci,id=fsdef0,fsdev=fsdef0,mount_tag=fileshare");
        }
    }

    @Override
    public void checkArgument(VMProperty property) throws VMLauncherException {
        File f;
        String fileshare = property.getPropertyValue().fileSharePath;
        if (fileshare != null && property.getPropertyValue().isFileShareSupport && !(f = new File(fileshare)).exists()) {
            throw new VMLauncherException(Messages.getString("FileShareOption.FileShareError.0"));
        }
    }
}

