/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.create;

import java.io.IOException;
import java.net.URL;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.ui.Main;
import org.tizen.emulator.manager.ui.controller.create.CreateDialog;
import org.tizen.emulator.manager.ui.controller.create.PlatformListController;
import org.tizen.emulator.manager.ui.controller.create.VMDialogData;
import org.tizen.emulator.manager.ui.controller.create.VMDialogPage;
import org.tizen.emulator.manager.ui.dialog.ButtonType;

public class PlatformListPage
implements VMDialogPage {
    private static PlatformListController controller = null;
    private static final URL PLATFORM_LIST_VIEW = Main.class.getResource("/view/create/platformListView.css");

    public PlatformListPage() {
        this.initController();
    }

    private void initController() {
        FXMLLoader loader = new FXMLLoader(CreateDialog.class.getResource("/view/create/platformListView.fxml"));
        try {
            loader.load();
            controller = (PlatformListController)loader.getController();
        }
        catch (IOException e) {
            e.printStackTrace();
            EMLogger.getLogger().warning(e.getMessage());
        }
        controller.getRootPane().getStylesheets().add((Object)PLATFORM_LIST_VIEW.toExternalForm());
    }

    @Override
    public void onPageShow(VMDialogData vmDialogData, SimpleBooleanProperty isInvalid) {
        controller.selectDefaultPlatform(vmDialogData.getPlatform());
        controller.setInvalidListener(isInvalid);
        controller.setNextButton(vmDialogData.getButtons().getButton(ButtonType.NEXT));
    }

    @Override
    public void setData(VMDialogData vmDialogData) {
        vmDialogData.setPlatform(controller.getPlatform());
    }

    @Override
    public Node getNode() {
        return controller.getRootPane();
    }

    @Override
    public String getTitle() {
        return "Platform";
    }

    @Override
    public String getDescription() {
        return "Select a System Image";
    }
}

