/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.platform.controller;

import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.tabview.item.TextViewItem;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;
import org.tizen.emulator.manager.vms.DiskImageFormat;
import org.tizen.emulator.manager.vms.helper.HelperClass;

public class PlatformNameViewController
extends ViewItemController {
    private TextViewItem textView;
    private boolean isModifiedByUser = false;
    private boolean isModifiedByPlatform = false;
    private final int MAX_NAME_LEN = 30;
    private DiskImageFormat imageFormat;
    private Platform platform;

    public PlatformNameViewController(Item item) {
        super(item);
    }

    @Override
    public void makeViewItem() {
        this.setViewItem(new TextViewItem());
    }

    @Override
    public ViewItem getViewItem() {
        return this.textView;
    }

    @Override
    public void setViewItem(ViewItem item) {
        this.textView = item instanceof TextViewItem ? (TextViewItem)item : new TextViewItem();
        this.textView.setMaxLen(30);
        this.textView.setMatchStr("[A-Za-z0-9-_()]");
        this.textView.setTitle(this.getTitle());
        this.textView.addEventHandler(EventType.Modify, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                if (!PlatformNameViewController.this.isModifiedByPlatform) {
                    PlatformNameViewController.this.isModifiedByUser = true;
                }
                PlatformNameViewController.this.checkValid();
                PlatformNameViewController.this.isModifiedByPlatform = false;
            }
        });
        ViewItemController.addChangeEventHandler("basePlatform", new EventHandler<ItemEvent>(){

            @Override
            public void handleEvent(ItemEvent event) {
                String name = PlatformNameViewController.this.textView.getText();
                if (name == null || name.isEmpty()) {
                    PlatformNameViewController.this.isModifiedByUser = false;
                }
                if (PlatformNameViewController.this.isModifiedByUser) {
                    return;
                }
                PlatformNameViewController.this.platform = (Platform)event.data;
                if (PlatformNameViewController.this.platform != null) {
                    PlatformNameViewController.this.isModifiedByPlatform = true;
                    PlatformNameViewController.this.textView.setText(PlatformNameViewController.getDefaultName(PlatformNameViewController.this.platform.getName()));
                    PlatformNameViewController.this.changeWidget();
                }
            }
        });
        ViewItemController.addChangeEventHandler("imageFormat", new EventHandler<ItemEvent>(){

            @Override
            public void handleEvent(ItemEvent event) {
                PlatformNameViewController.this.imageFormat = (DiskImageFormat)((Object)event.data);
                PlatformNameViewController.this.changeWidget();
            }
        });
    }

    private void changeWidget() {
        if (this.imageFormat == DiskImageFormat.QCOW2) {
            this.textView.setAsModifyItem();
        } else if (this.imageFormat == DiskImageFormat.RAW) {
            this.textView.setAsLabel(this.platform.getName() + "(" + this.imageFormat.getName() + ")");
        }
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        if (this.getMode() == MODE.MODIFY) {
            this.textView.setAsLabel(value.getStringValue(this.getName()));
        }
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        value.setStringValue(this.getName(), this.textView.getText());
    }

    @Override
    public void checkValid() {
        STATE newState;
        if (this.mode != MODE.CREATE) {
            return;
        }
        String errorMsg = "";
        String name = this.textView.getText();
        if (name.length() > 30) {
            errorMsg = "Max length of name is " + String.valueOf(30);
            newState = STATE.ERROR;
        } else if (name.isEmpty()) {
            errorMsg = "Please, input the platform name";
            newState = STATE.ESSENTIAL;
        } else {
            Platform platform = HelperClass.checkDuplicatePlatformImageName(name);
            if (platform != null) {
                newState = STATE.ERROR;
                errorMsg = "Same name already exist!" + StringResources.NEW_LINE + name + " ( " + platform.getName() + " )" + StringResources.NEW_LINE + "Path: " + platform.getImagePathList();
            } else {
                newState = STATE.OK;
            }
        }
        this.setItemState(newState, errorMsg);
    }

    private static String getDefaultName(String name) {
        String newName;
        int count = 1;
        name = name + "-";
        while (HelperClass.checkDuplicatePlatformImageName(newName = name + Integer.toString(count++)) != null) {
        }
        return newName;
    }
}

