/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.platform.controller;

import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.platform.PlatformList;
import org.tizen.emulator.manager.platform.Profile;
import org.tizen.emulator.manager.platform.ProfileList;
import org.tizen.emulator.manager.platform.StandardPlatform;
import org.tizen.emulator.manager.ui.platform.item.BasePlatformViewItem;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;

public class BasePlatformViewController
extends ViewItemController {
    private BasePlatformViewItem viewItem;
    private Platform platform;

    public BasePlatformViewController(Item item) {
        super(item);
    }

    @Override
    public void makeViewItem() {
        this.setViewItem(new BasePlatformViewItem());
    }

    @Override
    public ViewItem getViewItem() {
        return this.viewItem;
    }

    @Override
    public void setViewItem(ViewItem item) {
        if (item instanceof BasePlatformViewItem) {
            this.viewItem = (BasePlatformViewItem)item;
        }
        if (this.viewItem == null) {
            return;
        }
        this.viewItem.setTitle(this.getTitle());
        this.addListener();
    }

    private void addListener() {
        this.viewItem.addEventHandler(EventType.Selection, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                BasePlatformViewController.this.selectedItem(event);
            }
        });
    }

    private void initCombo(String profileName) {
        Profile newVMProfile = ProfileList.get(profileName);
        if (newVMProfile == null) {
            return;
        }
        for (Platform platform : PlatformList.getList()) {
            if (!newVMProfile.equals(platform.getProfile()) || !(platform instanceof StandardPlatform)) continue;
            this.viewItem.addItem(platform.getName(), platform);
        }
    }

    protected void selectedItem(Event event) {
        this.platform = (Platform)this.viewItem.getSelectedData();
        ItemEvent iEvent = new ItemEvent(this.getName());
        iEvent.data = this.platform;
        ViewItemController.sendChangeEvent(iEvent);
        this.changeLabels(this.platform);
    }

    private void changeLabels(Platform platform) {
        this.viewItem.setProfile(platform.getProfile().toString());
        this.viewItem.setArch(platform.getImageArch().toString());
        this.viewItem.setSkinShape(platform.getImageSkinShape().toString());
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        String profile = value.getStringValue("profile");
        this.initCombo(profile);
        if (this.mode == MODE.CREATE) {
            this.selectCombo();
        } else {
            this.platform = (Platform)value.getObjectValue(this.getName());
            this.viewItem.setAsLabel(this.platform.getName());
            this.changeLabels(this.platform);
        }
    }

    private void selectCombo() {
        if (this.viewItem.size() > 0) {
            this.viewItem.selectItem(0);
        }
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        value.setObjectValue(this.getName(), this.platform);
    }

    @Override
    public void checkValid() {
    }
}

