/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.platform.custom;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.vms.DiskImageFormat;

public class CustomPlatformImageValue {
    private String id = "";
    private String name = "";
    private String profile = "";
    private String platformName = "";
    private Platform platform = null;
    private final List<String> pathList = new ArrayList<String>();
    private DiskImageFormat imageFormat = DiskImageFormat.QCOW2;
    private String description = "";
    private boolean isAmendable = false;
    private String type = "custom";

    public CustomPlatformImageValue() {
    }

    public void setImagePathList(List<String> pathList) {
        for (String path : pathList) {
            this.setImageFilePath(path);
        }
    }

    public void setImageFilePath(String baseImagePath) {
        if (this.pathList.contains(baseImagePath)) {
            return;
        }
        this.pathList.add(baseImagePath);
    }

    public String getImageFilePath() {
        if (this.pathList.isEmpty()) {
            return "";
        }
        if (this.imageFormat == DiskImageFormat.QCOW2) {
            return this.pathList.get(0);
        }
        return "";
    }

    public CustomPlatformImageValue(List<String> rawImagePathList, Platform basePlatform) {
        this(basePlatform);
        for (String path : rawImagePathList) {
            this.pathList.add(path);
        }
        this.imageFormat = DiskImageFormat.RAW;
        this.setName(this.platformName + " (" + this.imageFormat.getName() + ")");
        this.setID(this.getName());
    }

    public CustomPlatformImageValue(String baseImagePath, Platform basePlatform) {
        this(basePlatform);
        this.pathList.add(baseImagePath);
        this.setName(baseImagePath.substring(baseImagePath.lastIndexOf(File.separator) + 1));
        this.setID(this.getName());
        this.imageFormat = DiskImageFormat.QCOW2;
    }

    private CustomPlatformImageValue(Platform basePlatform) {
        this.platform = basePlatform;
        this.platformName = basePlatform.getName();
        this.profile = basePlatform.getProfile().getName();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CustomPlatformImageValue)) {
            return false;
        }
        CustomPlatformImageValue value = (CustomPlatformImageValue)obj;
        if (!this.name.equals(value.getName())) {
            return false;
        }
        if (!this.profile.equals(value.getProfile())) {
            return false;
        }
        if (!this.platformName.equals(value.getPlatformName())) {
            return false;
        }
        if (this.platform != value.getPlatform()) {
            return false;
        }
        if (!this.pathList.equals(value.getPathList())) {
            return false;
        }
        if (!this.description.equals(value.getDescription())) {
            return false;
        }
        return this.isAmendable == value.isAmendable();
    }

    public String getID() {
        return this.id;
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String profile) {
        this.profile = profile;
    }

    public String getPlatformName() {
        return this.platformName;
    }

    public void setPlatformName(String platformName) {
        this.platformName = platformName;
    }

    public Platform getPlatform() {
        return this.platform;
    }

    public void setPlatform(Platform platform) {
        this.platform = platform;
    }

    public List<String> getPathList() {
        return this.pathList;
    }

    public DiskImageFormat getImageFormat() {
        return this.imageFormat;
    }

    public void setImageFormat(DiskImageFormat format) {
        this.imageFormat = format;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isAmendable() {
        return this.isAmendable;
    }

    public void setAmendable(boolean isAmendable) {
        this.isAmendable = isAmendable;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

