/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.control;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import org.tizen.emulator.manager.ui.control.ImageButton;
import org.tizen.emulator.manager.ui.resources.ImageKind;

public class TizenRadioButton
extends ImageButton
implements Toggle {
    private Object userData;
    private final Label textLabel;
    private ToggleGroup toggleGroup;

    public TizenRadioButton() {
        this("");
    }

    public TizenRadioButton(String text) {
        super(ImageKind.RADIO_NOR, ImageKind.RADIO_NOR_HOVER, ImageKind.RADIO_NOR_FOCUSED, ImageKind.RADIO_SEL, ImageKind.RADIO_SEL_HOVER, ImageKind.RADIO_SEL_FOCUSED);
        this.textLabel = new Label(text);
        this.pane.add((Node)this.textLabel, 1, 0);
        this.pane.setHgap(8.0);
        this.stateProperty.addListener((ChangeListener)new ChangeListener<ImageButton.BUTTON_STATE>(){

            public void changed(ObservableValue<? extends ImageButton.BUTTON_STATE> arg0, ImageButton.BUTTON_STATE arg1, ImageButton.BUTTON_STATE arg2) {
                TizenRadioButton.this.redrawText(arg2);
            }
        });
        this.pane.setFocusTraversable(true);
        this.pane.focusedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                TizenRadioButton.this.drawIcon();
                TizenRadioButton.this.redrawText((ImageButton.BUTTON_STATE)((Object)TizenRadioButton.this.stateProperty.get()));
            }
        });
        this.pane.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                KeyCode keyCode = event.getCode();
                switch (keyCode) {
                    case UP: 
                    case LEFT: {
                        TizenRadioButton.this.changeFocus(false);
                        break;
                    }
                    case DOWN: 
                    case RIGHT: {
                        TizenRadioButton.this.changeFocus(true);
                        break;
                    }
                    case ENTER: 
                    case SPACE: {
                        if (TizenRadioButton.this.isSelected) break;
                        TizenRadioButton.this.setSelected(true);
                        break;
                    }
                }
            }
        });
    }

    private void changeFocus(boolean isNext) {
        int newIndex;
        if (this.toggleGroup == null) {
            return;
        }
        ObservableList list = this.toggleGroup.getToggles();
        int currentIndex = 0;
        for (int i = 0; i < list.size(); ++i) {
            if (list.get(i) != this) continue;
            currentIndex = i;
            break;
        }
        int n = newIndex = isNext ? currentIndex + 1 : currentIndex - 1;
        if (newIndex < list.size() && newIndex >= 0) {
            ((TizenRadioButton)list.get((int)newIndex)).pane.requestFocus();
        }
    }

    private void redrawText(ImageButton.BUTTON_STATE bState) {
        if (this.pane.isFocused()) {
            this.textLabel.setStyle("-fx-text-fill: #008aee");
            return;
        }
        switch (bState) {
            case NORMAL: 
            case SELECT_NORMAL: {
                this.textLabel.setStyle("-fx-text-fill: #464646");
                break;
            }
            case HOVER: 
            case SELECT_HOVER: 
            case SELECT_PRESS: 
            case PRESS: {
                this.textLabel.setStyle("-fx-text-fill: #000000");
                break;
            }
        }
    }

    @Override
    protected void buttonReleased() {
        this.pane.requestFocus();
        if (this.isSelected) {
            return;
        }
        this.selectToggle();
    }

    private void selectToggle() {
        if (this.toggleGroup == null) {
            return;
        }
        this.toggleGroup.selectToggle((Toggle)this);
    }

    @Override
    public void setSelected(boolean selected) {
        if (this.isSelected == selected) {
            return;
        }
        super.setSelected(selected);
        if (selected) {
            this.selectToggle();
        }
    }

    public void setSpacing(double spacing) {
        this.pane.setHgap(spacing);
    }

    public void setText(String text) {
        this.textLabel.setText(text);
    }

    public String getText() {
        return this.textLabel.getText();
    }

    public void setToolTip(String text) {
        this.textLabel.setTooltip(new Tooltip(text));
    }

    public void setPrefHeight(int height) {
        this.pane.setPrefHeight((double)height);
    }

    public ObservableMap<Object, Object> getProperties() {
        return null;
    }

    public ToggleGroup getToggleGroup() {
        return this.toggleGroup;
    }

    public Object getUserData() {
        return this.userData;
    }

    public BooleanProperty selectedProperty() {
        return new SimpleBooleanProperty(this.isSelected);
    }

    public void setToggleGroup(ToggleGroup toggleGroup) {
        this.toggleGroup = toggleGroup;
        toggleGroup.getToggles().add((Object)this);
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public ObjectProperty<ToggleGroup> toggleGroupProperty() {
        return null;
    }
}

