/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.dialog;

import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import org.tizen.emulator.manager.ui.control.TizenCheckBox;
import org.tizen.emulator.manager.ui.dialog.ButtonType;
import org.tizen.emulator.manager.ui.dialog.CheckReturn;
import org.tizen.emulator.manager.ui.dialog.Dialog;
import org.tizen.emulator.manager.ui.dialog.MessageBoxButton;

public class MessageBox {
    public static ButtonType confirm(String message) {
        return MessageBox.confirm("Emulator Manager", message, ButtonType.OK);
    }

    public static ButtonType confirm(String title, String message) {
        return MessageBox.confirm(title, message, ButtonType.OK);
    }

    public static ButtonType confirm(String message, ButtonType type) {
        return MessageBox.confirm("Emulator Manager", message, type);
    }

    public static ButtonType confirm(String title, String message, ButtonType type) {
        Dialog dialog = new Dialog();
        dialog.setContentText(message);
        dialog.setTitle(title);
        dialog.getDialogPane().addButonType(ButtonType.CANCEL);
        dialog.getDialogPane().addButonType(type);
        return (ButtonType)dialog.showAndWait();
    }

    public static ButtonType error(String message) {
        return MessageBox.error("Emulator Manager", message);
    }

    public static ButtonType error(String title, String message) {
        Dialog dialog = new Dialog();
        dialog.setContentText(message);
        dialog.setTitle(title);
        dialog.getDialogPane().addButonType(ButtonType.OK);
        return (ButtonType)dialog.showAndWait();
    }

    public static CheckReturn check(String message, String checkMessage, boolean isChecked, ButtonType ... types) {
        MessageBoxButton[] buttons = new MessageBoxButton[types.length];
        for (int i = 0; i < types.length; ++i) {
            buttons[i] = new MessageBoxButton(types[i], "");
        }
        return MessageBox.check("Emulator Manager", message, checkMessage, isChecked, buttons);
    }

    public static CheckReturn check(String message, String checkMessage, ButtonType ... types) {
        return MessageBox.check(message, checkMessage, true, types);
    }

    public static CheckReturn check(String message, String checkMessage, boolean isChecked, MessageBoxButton ... buttons) {
        return MessageBox.check("Emulator Manager", message, checkMessage, isChecked, buttons);
    }

    public static CheckReturn check(String title, String message, String checkMessage, boolean isChecked, MessageBoxButton ... buttons) {
        Dialog<CheckReturn> dialog = new Dialog<CheckReturn>();
        VBox content = new VBox();
        content.getStyleClass().add((Object)"content-pane");
        Label labMsg = new Label(message);
        labMsg.getStyleClass().add((Object)"content-label");
        GridPane grid = new GridPane();
        grid.setPadding(new Insets(20.0, 20.0, 15.0, 15.0));
        final TizenCheckBox checkBox = new TizenCheckBox(checkMessage);
        checkBox.setSelected(isChecked);
        grid.add((Node)checkBox.getPane(), 1, 1);
        content.getChildren().add((Object)labMsg);
        content.getChildren().add((Object)grid);
        content.layout();
        dialog.getDialogPane().setContent((Node)content);
        dialog.setTitle(title);
        for (MessageBoxButton button : buttons) {
            dialog.getDialogPane().addButonType(button.buttonType);
        }
        for (MessageBoxButton button : buttons) {
            if (button.buttonText.isEmpty()) continue;
            dialog.getDialogPane().getButton(button.buttonType).setText(button.buttonText);
        }
        dialog.setResultConverter(new Callback<ButtonType, CheckReturn>(){

            public CheckReturn call(ButtonType param) {
                CheckReturn re = new CheckReturn();
                re.setButtonType(param);
                re.setChecked(checkBox.isSelected());
                return re;
            }
        });
        return (CheckReturn)dialog.showAndWait();
    }
}

