/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.console;

import org.tizen.emulator.manager.console.Command;
import org.tizen.emulator.manager.console.Option;
import org.tizen.emulator.manager.console.processor.ConsoleProcessor;
import org.tizen.emulator.manager.console.resources.Messages;
import org.tizen.emulator.manager.console.resources.StringResources;
import org.tizen.emulator.manager.console.util.OutputUtil;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.platform.PlatformList;
import org.tizen.emulator.manager.platform.Profile;
import org.tizen.emulator.manager.platform.ProfileList;

class ListVM
extends Command {
    public ListVM() {
        this.command = "list-vm";
        this.shortDescription = Messages.getString("ListVM.ShortDescription");
        this.description = Messages.getString("ListVM.Description");
        this.usage = Messages.getString("ListVM.Usage.1") + StringResources.NEW_LINE + Messages.getString("ListVM.Usage.2") + StringResources.NEW_LINE + Messages.getString("ListVM.Usage.3") + StringResources.NEW_LINE + Messages.getString("ListVM.Usage.4") + StringResources.NEW_LINE + Messages.getString("ListVM.Usage.5") + StringResources.NEW_LINE + Messages.getString("ListVM.Usage.6") + StringResources.NEW_LINE + Messages.getString("ListVM.Usage.7") + StringResources.NEW_LINE + Messages.getString("ListVM.Usage.8") + StringResources.NEW_LINE + Messages.getString("ListVM.Usage.9") + StringResources.NEW_LINE + Messages.getString("ListVM.Usage.10");
        this.optionList.add(new Option("d", "detail", StringResources.DESC_LIST_VM_DETAIL, "", false, false));
        this.optionList.add(new Option("c", "count", StringResources.DESC_LIST_VM_COUNT, "", false, false));
        this.optionList.add(new Option("p", "platform", StringResources.DESC_LIST_VM_PLATFORM, "", false, true, "PLATFORM"));
        this.optionList.add(new Option("P", "profile", StringResources.DESC_LIST_VM_PROFILE, "", false, true, "PROFILE"));
    }

    @Override
    public boolean process() {
        boolean isDetail = false;
        boolean isCount = false;
        Platform platform = null;
        Profile profile = null;
        for (Option c : this.optionList) {
            if (!c.isInCommandLine()) continue;
            switch (c.getShortName().charAt(0)) {
                case 'd': {
                    isDetail = true;
                    break;
                }
                case 'c': {
                    isCount = true;
                    break;
                }
                case 'p': {
                    String name = c.getCurrentValue();
                    platform = PlatformList.get(name);
                    if (platform != null) break;
                    OutputUtil.printError(name + " " + Messages.getString("Error.Platform.Not.Match"));
                    return false;
                }
                case 'P': {
                    String pName = c.getCurrentValue();
                    profile = ProfileList.get(pName);
                    if (profile != null) break;
                    OutputUtil.printError(pName + " " + Messages.getString("Error.Profile.Not.Match"));
                    return false;
                }
            }
        }
        ConsoleProcessor processor = new ConsoleProcessor();
        int count = 0;
        if (isCount) {
            count = platform != null ? processor.getCountOfVMList(platform) : (profile != null ? processor.getCountOfVMList(profile) : processor.getCountOfVMList());
            OutputUtil.print(String.valueOf(count));
        } else {
            count = profile == null || platform != null ? processor.printVMList(platform, isDetail) : processor.printVMList(profile, isDetail);
            if (count == 0) {
                OutputUtil.print(Messages.getString("ListVM.EmptyList"));
            }
        }
        return true;
    }
}

