/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.console;

import java.util.ArrayList;
import org.tizen.emulator.manager.console.Command;
import org.tizen.emulator.manager.console.Create;
import org.tizen.emulator.manager.console.CreateBaseImage;
import org.tizen.emulator.manager.console.Delete;
import org.tizen.emulator.manager.console.DeleteAll;
import org.tizen.emulator.manager.console.Detail;
import org.tizen.emulator.manager.console.Global;
import org.tizen.emulator.manager.console.Launch;
import org.tizen.emulator.manager.console.ListDevice;
import org.tizen.emulator.manager.console.ListPlatform;
import org.tizen.emulator.manager.console.ListVM;
import org.tizen.emulator.manager.console.Modify;
import org.tizen.emulator.manager.console.Reset;

public class CommandList {
    private static Global globalCommand = null;
    private static final ArrayList<Command> commandList = new ArrayList();
    private static final ArrayList<Command> showCommandList = new ArrayList();

    public static ArrayList<Command> getCommandList() {
        return showCommandList;
    }

    private static void addCommand(Command action) {
        if (!action.isInternalCommand()) {
            showCommandList.add(action);
        }
        commandList.add(action);
    }

    public static void makeCommandList() {
        globalCommand = new Global();
        CommandList.addCommand(new Create());
        CommandList.addCommand(new Delete());
        CommandList.addCommand(new Launch());
        CommandList.addCommand(new ListVM());
        CommandList.addCommand(new ListPlatform());
        CommandList.addCommand(new ListDevice());
        CommandList.addCommand(new Detail());
        CommandList.addCommand(new Modify());
        CommandList.addCommand(new Reset());
        CommandList.addCommand(new CreateBaseImage());
        CommandList.addCommand(new DeleteAll());
    }

    public static Command getGlobalCommand() {
        return globalCommand;
    }

    public static boolean isGlobalOption(String value) {
        if (globalCommand.findLongNameOption(value) != null) {
            return true;
        }
        return globalCommand.findShortNameOption(value) != null;
    }

    public static Command findCommand(String value) {
        for (Command a : commandList) {
            if (!a.getCommand().equals(value)) continue;
            return a;
        }
        return null;
    }
}

