/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.platform;

import java.io.File;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import org.tizen.emulator.manager.devices.CommonDeviceTemplateList;
import org.tizen.emulator.manager.devices.DeviceTemplate;
import org.tizen.emulator.manager.devices.DeviceTemplateUtil;
import org.tizen.emulator.manager.devices.DeviceTemplateValue;
import org.tizen.emulator.manager.platform.IPlatformResourceSelector;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.platform.PlatformResourceType;
import org.tizen.emulator.manager.platform.Profile;
import org.tizen.emulator.manager.platform.Skin;
import org.tizen.emulator.manager.platform.SkinList;
import org.tizen.emulator.manager.platform.StandardPlatformImageValue;
import org.tizen.emulator.manager.platform.Version;
import org.tizen.emulator.manager.plugin.EMPlugin;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.vms.VMKeeper;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.type.Architecture;
import org.tizen.emulator.manager.vms.type.RESOLUTION;
import org.tizen.emulator.manager.vms.type.SKIN_SHAPE;
import org.tizen.emulator.manager.vms.type.SKIN_TYPE;

public class StandardPlatform
extends Platform {
    private Architecture cpu;
    private SKIN_SHAPE skinShape;
    private String binaryVersion;
    private final EMPlugin plugin;
    private List<Skin> skinList = null;
    private VMProperty defaultProperty = null;
    private PlatformResourceType platformResourceType = null;
    private SortedSet<DeviceTemplate> deviceTemplateList = null;

    StandardPlatform(StandardPlatformImageValue value, EMPlugin plugin) {
        super(value.getImageFormat());
        this.plugin = plugin;
        this.setValue(value);
    }

    private void setValue(StandardPlatformImageValue value) {
        this.setImageName(value.getName());
        for (String path : value.getPathList()) {
            this.addImagePath(path);
        }
        this.setImageType(value.getType());
        this.setImageDescription(value.getDescription());
        this.cpu = value.getArchitecture();
        this.skinShape = value.getSkinShape();
        this.binaryVersion = value.getBinaryVersion();
        String name = this.getImageName();
        if (name == null || name.isEmpty()) {
            name = this.plugin.getPluginName();
            if (!this.skinShape.equals((Object)SKIN_SHAPE.SQUARE)) {
                name = name + "-" + this.skinShape.toString();
            }
            if (value.getVersion().equals("3.0")) {
                name = name + "-" + this.cpu.toString();
            }
        }
        this.setName(name);
    }

    @Override
    public String getPlatformPath() {
        return this.plugin.getPlatformPath();
    }

    @Override
    public Profile getProfile() {
        return this.plugin.getProfile();
    }

    @Override
    public Version getVersion() {
        return this.plugin.getVersion();
    }

    @Override
    public String getExtension() {
        return this.plugin.getExtension();
    }

    @Override
    public String getEmulatorDirPath() {
        return this.plugin.getEmulatorDir();
    }

    @Override
    public Architecture getImageArch() {
        return this.cpu;
    }

    @Override
    public SKIN_SHAPE getImageSkinShape() {
        return this.skinShape;
    }

    @Override
    public String getImageBinaryVersion() {
        return this.binaryVersion;
    }

    @Override
    public EMPlugin getPlugin() {
        return this.plugin;
    }

    @Override
    public List<Skin> getSkinList() {
        if (this.skinList != null) {
            return this.skinList;
        }
        this.skinList = SkinList.loadSkins(this.getPlatformPath() + FilePathResources.getPlatformSkinsSuffix(), this.skinShape);
        if (this.getPlatformResourceType() == PlatformResourceType.ALL) {
            for (Skin skin : SkinList.getCommonSkinList()) {
                if (!skin.getProfile().equals(this.getProfile().toString()) || skin.getType().equals((Object)SKIN_TYPE.PROFILE_SPECIFIC) && !skin.getSkinShapeList().hasShape(this.skinShape)) continue;
                boolean isExist = false;
                for (Skin s : this.skinList) {
                    if (!s.getName().equals(skin.getName())) continue;
                    isExist = true;
                    break;
                }
                if (isExist) continue;
                this.skinList.add(skin);
            }
        }
        return this.skinList;
    }

    @Override
    public Skin getSkinByPath(String path) {
        return SkinList.findSkinByPath(path, this.getSkinList());
    }

    @Override
    public Skin getSkinByName(String name) {
        return SkinList.findSkinByName(name, this.getSkinList());
    }

    @Override
    public SortedSet<Skin> getSkinList(RESOLUTION resolution) {
        return SkinList.findSkinList(resolution, this.getSkinList());
    }

    @Override
    public Skin getAvailableSkin(RESOLUTION resolution) {
        SortedSet<Skin> list = this.getSkinList(resolution);
        if (!list.isEmpty()) {
            return list.first();
        }
        if (!this.skinList.isEmpty()) {
            return this.skinList.get(0);
        }
        return null;
    }

    @Override
    public VMProperty getDefaultProperty() {
        if (this.defaultProperty == null) {
            this.defaultProperty = VMKeeper.loadProperty(this.getImageName(), this);
            if (this.defaultProperty == null) {
                // empty if block
            }
        }
        return this.defaultProperty;
    }

    private PlatformResourceType getPlatformResourceType() {
        if (this.platformResourceType == null) {
            IPlatformResourceSelector selector = (IPlatformResourceSelector)this.plugin.newInstance("Platform-Resource-Selector");
            this.platformResourceType = selector == null ? PlatformResourceType.ALL : selector.getPlatformResourceType();
        }
        return this.platformResourceType;
    }

    @Override
    public void loadDeviceTemplates() {
        this.deviceTemplateList = new TreeSet<DeviceTemplate>();
        DeviceTemplateUtil.loadTemplates(this.getPlatformPath() + File.separator + FilePathResources.getPlatformDeviceTemplateSuffix(), this.deviceTemplateList);
        DeviceTemplateUtil.loadTemplates(this.getCustomDeviceTemplatePath(), this.deviceTemplateList);
        for (DeviceTemplate deviceTemplate : this.deviceTemplateList) {
            deviceTemplate.getValue().setPlatformExtension(true);
        }
    }

    @Override
    public SortedSet<DeviceTemplate> getAvailableDeviceTemplates() {
        TreeSet<DeviceTemplate> availableTemplateList = new TreeSet<DeviceTemplate>();
        for (DeviceTemplate template : this.getDeviceTemplates()) {
            if (this.getImageSkinShape() != SKIN_SHAPE.NONE && template.getValue().getSkinShape() != this.getImageSkinShape()) continue;
            availableTemplateList.add(template);
        }
        for (DeviceTemplate template : CommonDeviceTemplateList.getDeviceTemplateList(false)) {
            DeviceTemplateValue value = template.getValue();
            if (value.isStandard() && this.getPlatformResourceType() != PlatformResourceType.ALL || !value.getProfile().equals(this.getProfile().getName()) || this.getImageSkinShape() != SKIN_SHAPE.NONE && this.getImageSkinShape() != value.getSkinShape()) continue;
            boolean isExist = false;
            for (DeviceTemplate existingTemplate : availableTemplateList) {
                if (!existingTemplate.equals(template)) continue;
                isExist = true;
                break;
            }
            if (isExist) continue;
            availableTemplateList.add(template);
        }
        return availableTemplateList;
    }

    @Override
    public SortedSet<DeviceTemplate> getDeviceTemplates() {
        if (this.deviceTemplateList == null) {
            this.loadDeviceTemplates();
        }
        return this.deviceTemplateList;
    }

    @Override
    public void addDeviceTemplate(DeviceTemplate template) {
        this.deviceTemplateList.add(template);
    }

    @Override
    public void removeDeviceTemplate(DeviceTemplate template) {
        this.deviceTemplateList.remove(template);
    }
}

