/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.platform.controller;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.ui.dialog.ButtonType;
import org.tizen.emulator.manager.ui.dialog.CheckReturn;
import org.tizen.emulator.manager.ui.dialog.MessageBox;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.controller.FileViewController;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.tabview.item.FileViewItem;
import org.tizen.emulator.manager.ui.template.item.Item;
import org.tizen.emulator.manager.vms.DiskImageFormat;
import org.tizen.emulator.manager.vms.type.Architecture;

public class ImageFileViewController
extends FileViewController {
    private DiskImageFormat imageFormat = DiskImageFormat.QCOW2;
    List<String> imagePathList = new ArrayList<String>();
    private static boolean doNotShowWarningAgain = false;

    public ImageFileViewController(Item item) {
        super(item);
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        String path = value.getStringValue(this.getName());
        if (this.mode == MODE.CREATE) {
            this.fileItem.setFile(path);
            this.fileItem.addFilter("Disk Image Files (*." + Architecture.x86.toString() + ", *." + Architecture.x86_64.toString() + ")", "*." + Architecture.x86.toString(), "*." + Architecture.x86_64.toString());
            this.fileItem.addFilter("All files", "*");
            this.addImageFormatChangeListener();
            this.addFileSelectedListener();
        } else {
            this.fileItem.setAsLabel(value.getStringValue(this.getName()));
        }
    }

    private void addImageFormatChangeListener() {
        ViewItemController.addChangeEventHandler("imageFormat", new EventHandler<ItemEvent>(){

            @Override
            public void handleEvent(ItemEvent event) {
                ImageFileViewController.this.imageFormat = (DiskImageFormat)((Object)event.data);
                if (ImageFileViewController.this.imageFormat == DiskImageFormat.QCOW2) {
                    ImageFileViewController.this.fileItem.setType(FileViewItem.Type.FILE);
                    ImageFileViewController.this.fileItem.setDialogTitle("Select a base image file");
                } else if (ImageFileViewController.this.imageFormat == DiskImageFormat.RAW) {
                    ImageFileViewController.this.fileItem.setType(FileViewItem.Type.DIR);
                    ImageFileViewController.this.fileItem.setDialogTitle("Select a raw image directory");
                }
                ImageFileViewController.this.fileItem.setFile("");
                ImageFileViewController.this.fileSelected();
            }
        });
    }

    private void addFileSelectedListener() {
        this.fileItem.addEventHandler(EventType.Selection, new EventHandler<Event>(){

            @Override
            public void handleEvent(Event event) {
                ImageFileViewController.this.fileSelected();
            }
        });
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        value.setObjectValue(this.getName(), this.imagePathList);
    }

    private void fileSelected() {
        File[] fileList;
        this.imagePathList.clear();
        File file = this.fileItem.getSelectedFile();
        if (file == null) {
            this.checkValid();
            return;
        }
        if (this.imageFormat == DiskImageFormat.QCOW2) {
            this.imagePathList.add(file.getPath());
        } else if (this.imageFormat == DiskImageFormat.RAW && (fileList = file.listFiles()) != null) {
            for (File f : fileList) {
                if (!f.getName().endsWith(".img")) continue;
                try {
                    this.imagePathList.add(f.getCanonicalPath());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        this.checkValid();
        this.showRawImageWarning();
    }

    private void showRawImageWarning() {
        String checkMsg;
        if (this.imageFormat == DiskImageFormat.QCOW2 || this.getState() != STATE.OK || doNotShowWarningAgain) {
            return;
        }
        String msg = "Following disk image files are detected." + StringResources.NEW_LINE;
        for (String path : this.imagePathList) {
            msg = msg + StringResources.NEW_LINE + " - " + path.substring(path.lastIndexOf(File.separator) + 1);
        }
        CheckReturn ret = MessageBox.check(msg = msg + StringResources.NEW_LINE + StringResources.NEW_LINE + "If the disk images are once used, they cannot be reset." + StringResources.NEW_LINE + "(If you would like to create another VM with above disk images, " + StringResources.NEW_LINE + "you have to backup disk images before the VM is launched.)" + StringResources.NEW_LINE, checkMsg = "Do not show me this message again", false, ButtonType.OK);
        if (ret != null && ret.isChecked()) {
            doNotShowWarningAgain = true;
        }
    }

    @Override
    public void checkValid() {
        if (this.mode != MODE.CREATE) {
            return;
        }
        STATE newState = STATE.OK;
        String message = "";
        if (this.fileItem.getSelectedFile() == null) {
            message = "Select platform image path";
            newState = STATE.ESSENTIAL;
        } else if (this.imageFormat == DiskImageFormat.RAW && this.imagePathList.isEmpty()) {
            message = "At least one raw image file (.img) should be in directory.";
            newState = STATE.ERROR;
        }
        this.setItemState(newState, message);
    }
}

