/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.item;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.HBox;
import org.tizen.emulator.manager.ui.control.TizenRadioButton;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;

public class RadioViewItem
extends ViewItem {
    private final HBox box = new HBox();
    private final ToggleGroup toggleGroup;
    private final List<TizenRadioButton> buttons;

    public RadioViewItem() {
        this.box.setPadding(new Insets(0.0));
        this.box.setAlignment(Pos.CENTER_LEFT);
        this.buttons = new ArrayList<TizenRadioButton>();
        this.toggleGroup = new ToggleGroup();
        this.toggleGroup.selectedToggleProperty().addListener((ChangeListener)new ChangeListener<Toggle>(){

            public void changed(ObservableValue<? extends Toggle> arg0, Toggle arg1, Toggle arg2) {
                Event event = new Event(EventType.Selection);
                event.data = RadioViewItem.this.toggleGroup.getSelectedToggle().getUserData();
                RadioViewItem.this.sendEvent(event);
            }
        });
        this.baseView.setViewItem((Node)this.box);
    }

    public void setSpacing(double spacing) {
        this.box.setSpacing(spacing);
    }

    public void setSelect(int index) {
        if (this.buttons.size() <= index) {
            return;
        }
        this.buttons.get(index).setSelected(true);
    }

    public Object getSelectedData() {
        return this.toggleGroup.getSelectedToggle().getUserData();
    }

    public void addButton(String text, Object data) {
        TizenRadioButton rb = new TizenRadioButton(text);
        this.box.getChildren().add((Object)rb.getPane());
        rb.setToggleGroup(this.toggleGroup);
        rb.setUserData(data);
        this.buttons.add(rb);
    }

    @Override
    public String toString() {
        return null;
    }
}

