/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.item;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TextField;
import javafx.scene.layout.VBox;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.EventType;
import org.tizen.emulator.manager.ui.tabview.event.IPEventType;
import org.tizen.emulator.manager.ui.tabview.item.SubViewItem;
import org.tizen.emulator.manager.ui.tabview.item.ViewItem;

public class NetTCPIPViewItem
extends ViewItem {
    private final CheckBox useDHCP;
    private final SubViewItem viewIP;
    private final SubViewItem viewSubnet;
    private final SubViewItem viewGateway;
    private final SubViewItem viewDNS;
    private final SubViewItem viewMAC;
    private final TextField textIP;
    private final TextField textNetmask;
    private final TextField textGateway;
    private final TextField textDNS;
    private final TextField textMAC;

    public void setCheck(boolean check) {
        this.useDHCP.selectedProperty().set(check);
    }

    public boolean isCheck() {
        return this.useDHCP.selectedProperty().get();
    }

    public void setIPAddress(String text) {
        this.textIP.setText(text);
    }

    public String getIPAddress() {
        return this.textIP.getText();
    }

    public void setNetMask(String text) {
        this.textNetmask.setText(text);
    }

    public String getNetMask() {
        return this.textNetmask.getText();
    }

    public void setGateway(String text) {
        this.textGateway.setText(text);
    }

    public String getGateway() {
        return this.textGateway.getText();
    }

    public void setDNSAddress(String text) {
        this.textDNS.setText(text);
    }

    public String getDNSAddress() {
        return this.textDNS.getText();
    }

    public void setMACAddress(String text) {
        this.textMAC.setText(text);
    }

    public String getMACAddress() {
        return this.textMAC.getText();
    }

    public void setIPState(STATE state, String msg) {
        this.viewIP.setState(state);
        this.viewIP.setStateToolTip(msg);
    }

    public void setSubnetState(STATE state, String msg) {
        this.viewSubnet.setState(state);
        this.viewSubnet.setStateToolTip(msg);
    }

    public void setGatewayState(STATE state, String msg) {
        this.viewGateway.setState(state);
        this.viewGateway.setStateToolTip(msg);
    }

    public void setDNSState(STATE state, String msg) {
        this.viewDNS.setState(state);
        this.viewDNS.setStateToolTip(msg);
    }

    public void setMACState(STATE state, String msg) {
        this.viewMAC.setState(state);
        this.viewMAC.setStateToolTip(msg);
    }

    public STATE getState() {
        if (this.viewIP.getState() != STATE.OK) {
            return STATE.ERROR;
        }
        if (this.viewSubnet.getState() != STATE.OK) {
            return STATE.ERROR;
        }
        if (this.viewGateway.getState() != STATE.OK) {
            return STATE.ERROR;
        }
        if (this.viewDNS.getState() != STATE.OK) {
            return STATE.ERROR;
        }
        if (this.viewMAC.getState() != STATE.OK) {
            return STATE.ERROR;
        }
        return STATE.OK;
    }

    public void setEnableTextField(boolean isEnable) {
        this.textIP.setDisable(!isEnable);
        this.textNetmask.setDisable(!isEnable);
        this.textDNS.setDisable(!isEnable);
        this.textGateway.setDisable(!isEnable);
        this.viewIP.setDisable(!isEnable);
        this.viewSubnet.setDisable(!isEnable);
        this.viewGateway.setDisable(!isEnable);
        this.viewDNS.setDisable(!isEnable);
    }

    @Override
    public void setEnable(boolean isEnable) {
        this.useDHCP.setDisable(!isEnable);
        this.textIP.setDisable(!isEnable);
        this.textNetmask.setDisable(!isEnable);
        this.textGateway.setDisable(!isEnable);
        this.textDNS.setDisable(!isEnable);
        this.textMAC.setDisable(!isEnable);
        this.viewIP.setDisable(!isEnable);
        this.viewSubnet.setDisable(!isEnable);
        this.viewGateway.setDisable(!isEnable);
        this.viewDNS.setDisable(!isEnable);
        this.viewMAC.setDisable(!isEnable);
    }

    @Override
    public boolean isEnabled() {
        return !this.textIP.isDisable();
    }

    public NetTCPIPViewItem() {
        VBox mainBox = new VBox();
        this.useDHCP = new CheckBox();
        this.useDHCP.setText("Use DHCP");
        mainBox.getChildren().add((Object)this.useDHCP);
        this.viewIP = new SubViewItem();
        this.viewIP.setTitle("IP Address");
        this.viewSubnet = new SubViewItem();
        this.viewSubnet.setTitle("Subnet");
        this.viewGateway = new SubViewItem();
        this.viewGateway.setTitle("Gateway");
        this.viewDNS = new SubViewItem();
        this.viewDNS.setTitle("DNS");
        this.viewMAC = new SubViewItem();
        this.viewMAC.setTitle("MAC");
        this.textIP = new TextField();
        this.textNetmask = new TextField();
        this.textGateway = new TextField();
        this.textDNS = new TextField();
        this.textMAC = new TextField();
        this.textMAC.setEditable(false);
        this.addListener();
        this.viewIP.setViewItem((Node)this.textIP);
        this.viewSubnet.setViewItem((Node)this.textNetmask);
        this.viewGateway.setViewItem((Node)this.textGateway);
        this.viewDNS.setViewItem((Node)this.textDNS);
        this.viewMAC.setViewItem((Node)this.textMAC);
        mainBox.getChildren().add((Object)this.viewIP.getBasePane());
        mainBox.getChildren().add((Object)this.viewSubnet.getBasePane());
        mainBox.getChildren().add((Object)this.viewGateway.getBasePane());
        mainBox.getChildren().add((Object)this.viewDNS.getBasePane());
        mainBox.getChildren().add((Object)this.viewMAC.getBasePane());
        VBox.setMargin((Node)this.useDHCP, (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
        VBox.setMargin((Node)this.viewIP.getBasePane(), (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
        VBox.setMargin((Node)this.viewSubnet.getBasePane(), (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
        VBox.setMargin((Node)this.viewGateway.getBasePane(), (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
        VBox.setMargin((Node)this.viewDNS.getBasePane(), (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
        VBox.setMargin((Node)this.viewMAC.getBasePane(), (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
        this.baseView.setPrefHeight(230.0);
        this.baseView.setViewItem((Node)mainBox);
        this.baseView.removeStateLabel();
        this.baseView.setTitle("TCP/IPv4 for VM");
    }

    private void addListener() {
        this.useDHCP.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Event viewEvent = new Event(EventType.Selection);
                NetTCPIPViewItem.this.sendEvent(viewEvent);
            }
        });
        this.textIP.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                Event event = new Event(IPEventType.IP);
                event.text = arg2;
                NetTCPIPViewItem.this.sendEvent(event);
            }
        });
        this.textNetmask.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                Event event = new Event(IPEventType.NETMASK);
                event.text = arg2;
                NetTCPIPViewItem.this.sendEvent(event);
            }
        });
        this.textGateway.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                Event event = new Event(IPEventType.GATEWAY);
                event.text = arg2;
                NetTCPIPViewItem.this.sendEvent(event);
            }
        });
        this.textDNS.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                Event event = new Event(IPEventType.DNS);
                event.text = arg2;
                NetTCPIPViewItem.this.sendEvent(event);
            }
        });
        this.textMAC.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                Event event = new Event(IPEventType.MAC);
                event.text = arg2;
                NetTCPIPViewItem.this.sendEvent(event);
            }
        });
    }

    @Override
    public String toString() {
        return this.textIP.getText();
    }
}

