/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.helper;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;
import java.util.logging.Level;
import org.tizen.emulator.manager.Messages;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;

public class QemuImgProc {
    private List<String> cmd = null;
    private boolean isError = false;
    private String errorMsg = null;

    public QemuImgProc(List<String> cmd) {
        this.cmd = cmd;
    }

    public String RunningForCheckImg() {
        assert (this.cmd != null);
        this.isError = false;
        ProcessBuilder pb = new ProcessBuilder(this.cmd);
        pb.directory(new File(FilePathResources.getEmulatorCheckToolPath()));
        try {
            Process process = pb.start();
            if (process == null) {
                return this.errorMsg;
            }
            final BufferedReader error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            final BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String str = null;
                        do {
                            if ((str = error.readLine()) == null) continue;
                            QemuImgProc.this.isError = true;
                            EMLogger.getLogger().log(Level.WARNING, "Failed check base image...(from qemu-img)" + StringResources.NEW_LINE + str);
                        } while (str != null);
                    }
                    catch (IOException e) {
                        QemuImgProc.this.isError = true;
                        EMLogger.getLogger().log(Level.WARNING, "Failed check base image...(stderr of qemu-img)" + StringResources.NEW_LINE + e.getMessage());
                    }
                    finally {
                        try {
                            error.close();
                        }
                        catch (IOException e) {
                            EMLogger.getLogger().log(Level.WARNING, e.getMessage());
                        }
                    }
                }
            }).start();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String str = null;
                        do {
                            if ((str = input.readLine()) == null) continue;
                            if (str.contains("file format:")) {
                                if (str.contains("qcow2")) continue;
                                QemuImgProc.this.isError = true;
                                QemuImgProc.this.errorMsg = Messages.getString("QemuImgProc.FormatError.0") + StringResources.NEW_LINE + Messages.getString("QemuImgProc.FormatError.1") + (String)QemuImgProc.this.cmd.get(2);
                            } else {
                                if (str == null || !str.contains("backing file:")) continue;
                                QemuImgProc.this.isError = true;
                                QemuImgProc.this.errorMsg = Messages.getString("QemuImgProc.BaseImageError.0") + StringResources.NEW_LINE + Messages.getString("QemuImgProc.BaseImageError.1") + StringResources.NEW_LINE;
                            }
                            break;
                        } while (str != null);
                    }
                    catch (IOException e) {
                        QemuImgProc.this.isError = true;
                        EMLogger.getLogger().log(Level.WARNING, "Failed check base image...(stdout of qemu-img)" + StringResources.NEW_LINE + e.getMessage());
                    }
                    finally {
                        try {
                            input.close();
                        }
                        catch (IOException e) {
                            EMLogger.getLogger().log(Level.WARNING, e.getMessage());
                        }
                    }
                }
            }).start();
            try {
                if (process.waitFor() != 0) {
                    this.isError = true;
                    EMLogger.getLogger().log(Level.WARNING, "Error while running 'qemu-img'. Exit value : " + process.exitValue());
                    this.errorMsg = Messages.getString("QemuImgProc.Qemu-imgError.0") + process.exitValue() + StringResources.NEW_LINE + Messages.getString("QemuImgProc.Qemu-imgError.1") + FilePathResources.getTizenSDKDataVmsPath() + File.separator + "emulator-manager)";
                }
            }
            catch (InterruptedException e) {
                this.isError = true;
                EMLogger.getLogger().log(Level.WARNING, "Error while running 'qemu-img'." + StringResources.NEW_LINE + e.getMessage());
            }
            if (this.isError && this.errorMsg == null) {
                this.errorMsg = Messages.getString("QemuImgProc.BaseImageError.2") + StringResources.NEW_LINE + Messages.getString("QemuImgProc.BaseImageError.3");
            }
        }
        catch (IOException e) {
            return Messages.getString("QemuImgProc.BaseImageError.2") + e.getMessage();
        }
        return this.errorMsg;
    }

    public boolean Running() {
        assert (this.cmd != null);
        this.isError = false;
        ProcessBuilder pb = new ProcessBuilder(this.cmd);
        pb.directory(new File(FilePathResources.getEmulatorCheckToolPath()));
        try {
            Process process = pb.start();
            if (process == null) {
                return false;
            }
            final BufferedReader error = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String str = null;
                        do {
                            if ((str = error.readLine()) == null) continue;
                            QemuImgProc.this.isError = true;
                            EMLogger.getLogger().log(Level.WARNING, "Error while running 'qemu-img'" + StringResources.NEW_LINE + str);
                        } while (str != null);
                    }
                    catch (IOException e) {
                        QemuImgProc.this.isError = true;
                        EMLogger.getLogger().log(Level.WARNING, "Error while running 'qemu-img'(stderr)" + StringResources.NEW_LINE + e.getMessage());
                    }
                    finally {
                        try {
                            error.close();
                        }
                        catch (IOException e) {
                            EMLogger.getLogger().log(Level.WARNING, e.getMessage());
                        }
                    }
                }
            }).start();
            try {
                if (process.waitFor() != 0) {
                    this.isError = true;
                    EMLogger.getLogger().log(Level.WARNING, "Error while running 'qemu-img'. Exit value : " + process.exitValue());
                }
            }
            catch (InterruptedException e) {
                this.isError = true;
                EMLogger.getLogger().log(Level.WARNING, "Error while running 'qemu-img'." + StringResources.NEW_LINE + e.getMessage());
            }
            if (this.isError) {
                return false;
            }
        }
        catch (IOException e) {
            EMLogger.getLogger().log(Level.WARNING, "Failed check base image..." + e.getMessage());
            return false;
        }
        return true;
    }
}

