/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.controller.create;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ListView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.WindowEvent;
import org.tizen.emulator.manager.devices.CommonDeviceTemplateList;
import org.tizen.emulator.manager.devices.DeviceTemplate;
import org.tizen.emulator.manager.devices.DeviceTemplatePriority;
import org.tizen.emulator.manager.devices.DeviceTemplateType;
import org.tizen.emulator.manager.devices.DeviceTemplateUtil;
import org.tizen.emulator.manager.devices.DeviceTemplateValue;
import org.tizen.emulator.manager.devices.DeviceWorkerException;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.ui.control.ImageButton;
import org.tizen.emulator.manager.ui.control.SimpleEvent;
import org.tizen.emulator.manager.ui.controller.create.DeviceTemplateData;
import org.tizen.emulator.manager.ui.controller.create.DeviceTemplateListCell;
import org.tizen.emulator.manager.ui.controller.create.DeviceTemplatePropertyView;
import org.tizen.emulator.manager.ui.controller.create.VMDialogData;
import org.tizen.emulator.manager.ui.controller.vms.ROW_STATE;
import org.tizen.emulator.manager.ui.dialog.ButtonBar;
import org.tizen.emulator.manager.ui.dialog.ButtonType;
import org.tizen.emulator.manager.ui.dialog.MessageBox;
import org.tizen.emulator.manager.ui.resources.ImageKind;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;

public class DeviceTemplateListController
implements Initializable {
    @FXML
    private VBox rootPane;
    @FXML
    private HBox buttonBox;
    private ImageButton refreshBtn;
    private ImageButton editBtn;
    private ImageButton cloneBtn;
    private ImageButton deleteBtn;
    private ImageButton addBtn;
    private Button nextButton;
    private final int PROPERTY_VIEW_WIDTH = 400;
    static final int PROPERTY_VIEW_HEIGHT = 540;
    private VMDialogData dialogData;
    private Platform platform;
    @FXML
    private ListView<DeviceTemplateData> listView;
    ObservableList<DeviceTemplateData> listData = FXCollections.observableArrayList();

    public void initialize(URL arg0, ResourceBundle arg1) {
        this.rootPane.getStyleClass().add((Object)"root-pane");
        this.rootPane.setPadding(new Insets(0.0, 20.0, 20.0, 20.0));
        this.initButtons();
        this.initListView();
    }

    private void initListView() {
        this.listView.setItems(this.listData);
        this.listView.setCellFactory(DeviceTemplateListCell.extractor());
        this.listView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<DeviceTemplateData>(){

            public void changed(ObservableValue<? extends DeviceTemplateData> arg0, DeviceTemplateData arg1, DeviceTemplateData arg2) {
                if (arg2 == null) {
                    return;
                }
                arg2.getState().set((Object)ROW_STATE.SELECTED);
                for (DeviceTemplateData data : DeviceTemplateListController.this.listData) {
                    if (data.getName().equals(arg2.getName())) continue;
                    data.getState().set((Object)ROW_STATE.NORMAL);
                }
                ItemEvent iEvent = new ItemEvent("deviceTemplate");
                iEvent.oldValue = arg1 == null ? "" : arg1.getName();
                iEvent.newValue = arg2.getName();
                iEvent.oldState = STATE.OK;
                iEvent.newState = STATE.OK;
                iEvent.data = arg2.getTemplate();
                ViewItemController.sendChangeEvent(iEvent);
            }
        });
        this.listView.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                if (event.getCode() == KeyCode.DELETE) {
                    DeviceTemplateListController.this.deleteClicked();
                }
            }
        });
        this.listView.addEventHandler(SimpleEvent.SIMPLE_EVENT, (EventHandler)new EventHandler<SimpleEvent>(){

            public void handle(SimpleEvent arg0) {
                DeviceTemplateListController.this.nextButton.fire();
            }
        });
    }

    private void initButtons() {
        this.buttonBox.getStyleClass().add((Object)"menu-buttons");
        this.buttonBox.setAlignment(Pos.CENTER_RIGHT);
        this.buttonBox.setSpacing(14.0);
        this.refreshBtn = new ImageButton(ImageKind.PLATFORM_REFRESH_NOR, ImageKind.PLATFORM_REFRESH_OVER, ImageKind.PLATFORM_REFRESH_SEL);
        this.editBtn = new ImageButton(ImageKind.PLATFORM_EDIT_NOR, ImageKind.PLATFORM_EDIT_OVER, ImageKind.PLATFORM_EDIT_SEL, ImageKind.PLATFORM_EDIT_SEL);
        this.cloneBtn = new ImageButton(ImageKind.PLATFORM_CLONE_NOR, ImageKind.PLATFORM_CLONE_OVER, ImageKind.PLATFORM_CLONE_SEL, ImageKind.PLATFORM_CLONE_SEL);
        this.deleteBtn = new ImageButton(ImageKind.PLATFORM_DELETE_NOR, ImageKind.PLATFORM_DELETE_OVER, ImageKind.PLATFORM_DELETE_SEL);
        this.addBtn = new ImageButton(ImageKind.PLATFORM_ADD_NOR, ImageKind.PLATFORM_ADD_OVER, ImageKind.PLATFORM_ADD_SEL, ImageKind.PLATFORM_ADD_SEL);
        this.buttonBox.getChildren().addAll((Object[])new Node[]{this.refreshBtn.getPane(), this.editBtn.getPane(), this.cloneBtn.getPane(), this.addBtn.getPane(), this.deleteBtn.getPane()});
        this.addBtn.setOnMouseClicked(new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                DeviceTemplateListController.this.openPropertyView(MODE.CREATE);
            }
        });
        this.refreshBtn.setOnMouseClicked(new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                DeviceTemplateListController.this.refreshClicked();
            }
        });
        this.deleteBtn.setOnMouseClicked(new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                DeviceTemplateListController.this.deleteClicked();
            }
        });
        this.cloneBtn.setOnMouseClicked(new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                DeviceTemplateListController.this.openPropertyView(MODE.CLONE);
            }
        });
        this.editBtn.setOnMouseClicked(new EventHandler<MouseEvent>(){

            public void handle(MouseEvent arg0) {
                DeviceTemplateListController.this.openPropertyView(MODE.MODIFY);
            }
        });
        this.listView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<DeviceTemplateData>(){

            public void changed(ObservableValue<? extends DeviceTemplateData> arg0, DeviceTemplateData arg1, DeviceTemplateData arg2) {
                if (arg2 == null) {
                    return;
                }
                DeviceTemplateListController.this.editBtn.setDisable(!arg2.isCustom());
                DeviceTemplateListController.this.deleteBtn.setDisable(!arg2.isCustom());
            }
        });
        this.refreshBtn.setTooltipText("refresh list");
        this.editBtn.setTooltipText("edit template");
        this.cloneBtn.setTooltipText("clone template");
        this.addBtn.setTooltipText("add new template");
        this.deleteBtn.setTooltipText("delete");
    }

    public void selectDefaultData(DeviceTemplate template) {
        if (this.listData.size() <= 0) {
            return;
        }
        if (template == null) {
            this.listView.getSelectionModel().selectFirst();
        } else {
            for (DeviceTemplateData data : this.listData) {
                if (!template.equals(data.getTemplate())) continue;
                this.listView.getSelectionModel().select((Object)data);
                return;
            }
            this.listView.getSelectionModel().selectFirst();
        }
    }

    public void setVMDialogData(VMDialogData dialogData) {
        this.dialogData = dialogData;
    }

    private void refreshClicked() {
        DeviceTemplateUtil.reloadDeviceTemplate(this.platform);
        this.makeDataList(this.platform);
        this.listView.getSelectionModel().selectFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteClicked() {
        DeviceTemplateData data = (DeviceTemplateData)this.listView.getSelectionModel().getSelectedItem();
        if (data == null) {
            return;
        }
        if (data.getTemplate().getValue().isStandard()) {
            return;
        }
        ButtonType returnType = MessageBox.confirm("Are you sure you want to delete" + StringResources.NEW_LINE + "the selected device template?", new ButtonType("Delete", ButtonBar.ButtonData.OK_DONE));
        if (returnType == null || returnType == ButtonType.CANCEL) {
            return;
        }
        int index = this.listView.getSelectionModel().getSelectedIndex();
        DeviceTemplate template = data.getTemplate();
        try {
            template.delete();
        }
        catch (DeviceWorkerException e) {
            EMLogger.getLogger().warning(e.getMessage());
            MessageBox.error(e.getMessage());
        }
        finally {
            this.updateListViewData(index, template);
        }
    }

    private void openPropertyView(MODE mode) {
        DeviceTemplateValue value;
        final DeviceTemplatePropertyView view = new DeviceTemplatePropertyView(mode);
        final Platform platform = this.dialogData.getPlatform();
        if (mode == MODE.CREATE) {
            value = DeviceTemplateValue.createDefaultValue(platform.getProfile().getName());
            value.setSkinShape(platform.getImageSkinShape());
        } else {
            if (!this.checkIfTemplateExists()) {
                return;
            }
            DeviceTemplateData templateData = (DeviceTemplateData)this.listView.getSelectionModel().selectedItemProperty().get();
            assert (templateData != null);
            value = new DeviceTemplateValue(templateData.getTemplate().getValue());
        }
        view.setDeviceTemplateValue(value);
        view.createItems(platform);
        view.setConfirmButtonClicked(new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                DeviceTemplateValue value = view.getValue();
                MODE mode = view.getMode();
                DeviceTemplateUtil.setTemplateSkin(value, platform);
                if (mode == MODE.CREATE || mode == MODE.CLONE) {
                    DeviceTemplateListController.this.createDeviceTemplate(value);
                } else if (mode == MODE.MODIFY) {
                    DeviceTemplateListController.this.modifyDeviceTemplate(value);
                }
                view.closePropertyView();
            }
        });
        view.setCancelButtonClicked(new EventHandler<ActionEvent>(){

            public void handle(ActionEvent arg0) {
                view.closePropertyView();
            }
        });
        view.openPropertyView(this.rootPane.getScene().getWindow(), "Template Configuration", 400, 540);
        view.getButtons().getButton(ButtonType.OK).requestFocus();
        view.setOnClosed(new EventHandler<WindowEvent>(){

            public void handle(WindowEvent arg0) {
                DeviceTemplateListController.this.addBtn.setSelected(false);
                DeviceTemplateListController.this.editBtn.setSelected(false);
                DeviceTemplateListController.this.cloneBtn.setSelected(false);
            }
        });
    }

    private void createDeviceTemplate(DeviceTemplateValue value) {
        if (value == null) {
            return;
        }
        value.setType(DeviceTemplateType.CUSTOM);
        value.setPriority(DeviceTemplatePriority.CUSTOM);
        DeviceTemplate template = new DeviceTemplate();
        try {
            String saveDir = value.isPlatformExtension() ? this.platform.getCustomDeviceTemplatePath() : FilePathResources.getTizenSDKDataDeviceCommonPath();
            template.create(value, saveDir);
            DeviceTemplateData data = new DeviceTemplateData(template, this.platform.getVersion().toString());
            this.listData.add((Object)data);
            this.listView.getSelectionModel().select((Object)data);
            this.listView.scrollTo(this.listView.getSelectionModel().getSelectedIndex());
            if (value.isPlatformExtension()) {
                this.platform.addDeviceTemplate(template);
            } else {
                CommonDeviceTemplateList.addTemplate(template);
            }
        }
        catch (DeviceWorkerException e) {
            EMLogger.getLogger().warning(e.getMessage());
            MessageBox.error(e.getMessage());
        }
    }

    private void modifyDeviceTemplate(DeviceTemplateValue value) {
        if (value == null) {
            return;
        }
        value.updateVersion();
        DeviceTemplateData templateData = (DeviceTemplateData)this.listView.getSelectionModel().selectedItemProperty().get();
        int index = this.listView.getSelectionModel().getSelectedIndex();
        try {
            DeviceTemplate template = templateData.getTemplate();
            template.modify(value);
            this.listData.remove(index);
            this.listData.add(index, (Object)new DeviceTemplateData(template, this.platform.getVersion().toString()));
            this.listView.getSelectionModel().select(index);
        }
        catch (DeviceWorkerException e) {
            EMLogger.getLogger().warning(e.getMessage());
            MessageBox.error(e.getMessage());
        }
    }

    public void makeDataList(Platform platform) {
        assert (platform != null);
        this.platform = platform;
        this.listData.clear();
        for (DeviceTemplate template : DeviceTemplateUtil.getDeviceTemplateListByPlatform(platform)) {
            this.listData.add((Object)new DeviceTemplateData(template, platform.getVersion().toString()));
        }
    }

    public Pane getRootPane() {
        return this.rootPane;
    }

    public DeviceTemplate getDeviceTemplate() {
        return ((DeviceTemplateData)this.listView.getSelectionModel().selectedItemProperty().get()).getTemplate();
    }

    public void setNextButton(Button button) {
        this.nextButton = button;
    }

    public boolean checkIfTemplateExists() {
        DeviceTemplateData data = (DeviceTemplateData)this.listView.getSelectionModel().getSelectedItem();
        if (data == null) {
            return false;
        }
        int index = this.listView.getSelectionModel().getSelectedIndex();
        if (index < 0) {
            return false;
        }
        DeviceTemplate template = data.getTemplate();
        if (template.getTemplateFile().exists()) {
            return true;
        }
        MessageBox.error("Device template file does not exist: " + StringResources.NEW_LINE + template.getTemplateFile().getAbsolutePath());
        this.updateListViewData(index, template);
        return false;
    }

    private void updateListViewData(int index, DeviceTemplate template) {
        this.listData.remove(index);
        if (this.listData.size() > 0) {
            if (index == this.listData.size()) {
                this.listView.getSelectionModel().select(index - 1);
            } else {
                this.listView.getSelectionModel().select(index);
            }
        }
        if (template.getValue().isPlatformExtension()) {
            this.platform.removeDeviceTemplate(template);
        } else {
            CommonDeviceTemplateList.removeTemplate(template);
        }
    }
}

