/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms.option;

import java.io.File;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.vms.VMProperty;
import org.tizen.emulator.manager.vms.exception.VMLauncherException;
import org.tizen.emulator.manager.vms.option.LaunchConfig;
import org.tizen.emulator.manager.vms.option.OPTION_KEY;
import org.tizen.emulator.manager.vms.option.Option;
import org.tizen.emulator.manager.vms.type.Architecture;

public class CommonOption
extends Option {
    @Override
    public void getLaunchArgument(LaunchConfig config, VMProperty property) throws VMLauncherException {
        config.addVariableWithSpace(OPTION_KEY.VAR_VMS_PATH, FilePathResources.getTizenSDKDataVmsPath());
        config.addVariable(OPTION_KEY.VAR_PROFILE, property.getPropertyValue().getProfile() + (property.getPropertyValue().getProfileExtension().isEmpty() ? "" : "-" + property.getPropertyValue().getProfileExtension()));
        Architecture arch = property.getPropertyValue().getImageArch();
        if (arch == null) {
            arch = Architecture.x86;
        }
        config.addVariable(OPTION_KEY.VAR_IMAGE_ARCH, arch.toString());
        config.addKernelOption("console", "ttyS0");
        config.addVariableWithSpace(OPTION_KEY.VAR_KERNEL_LOG, CommonOption.varForm(OPTION_KEY.VAR_VMS_PATH) + File.separator + CommonOption.varForm(OPTION_KEY.VAR_VM_NAME) + File.separator + "logs" + File.separator + "emulator.klog");
        config.addQemuOption("-chardev", "file,path=" + CommonOption.varForm(OPTION_KEY.VAR_KERNEL_LOG) + ",id=con0");
        config.addQemuOption("-device isa-serial,chardev=con0");
        config.addQemuOption("-device virtio-serial");
        if (OSUtil.isWin()) {
            config.addQemuOption("### virtual console for telnet client");
            config.addQemuOption("#-chardev socket,port=2222,host=0.0.0.0,server,nowait,id=virtcon0");
            config.addQemuOption("#-device virtconsole,chardev=virtcon0");
        } else {
            config.addQemuOption("### virtual console for unix socket client");
            config.addQemuOption("#-chardev socket,path=/tmp/virtcon,server,nowait,id=virtcon0");
            config.addQemuOption("#-device virtconsole,chardev=virtcon0");
            config.addQemuOption("### virtual console for telnet client");
            config.addQemuOption("#-chardev socket,port=2222,host=0.0.0.0,server,nowait,id=virtcon1");
            config.addQemuOption("#-device virtconsole,chardev=virtcon1");
        }
        String emulatorPath = property.getPropertyValue().getPlatform().getEmulatorDirPath();
        config.addVariableWithSpace(OPTION_KEY.VAR_BIOS_PATH, emulatorPath + FilePathResources.getEmulatorBiosSuffix());
        config.addQemuOption("-L", CommonOption.varForm(OPTION_KEY.VAR_BIOS_PATH));
        config.addVariableWithSpace(OPTION_KEY.VAR_KERNEL, emulatorPath + FilePathResources.getEmulatorKernelSuffix() + File.separator + "bzImage." + CommonOption.varForm(OPTION_KEY.VAR_IMAGE_ARCH));
        config.addQemuOption("-kernel", CommonOption.varForm(OPTION_KEY.VAR_KERNEL));
        config.addQemuOption("-append", CommonOption.varForm(OPTION_KEY.VAR_APPEND));
        String version = property.getPropertyValue().getImageVersion();
        if (CommonOption.isGreaterThanOrEqualTo(version, "2.3.2")) {
            config.addVariable(OPTION_KEY.VAR_PLATFORM_VERSION, "tizen-" + version);
        }
    }
}

