/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.controller;

import javafx.application.Platform;
import org.tizen.emulator.manager.network.NetworkUtil;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.ui.Messages;
import org.tizen.emulator.manager.ui.dialog.ButtonType;
import org.tizen.emulator.manager.ui.dialog.CheckReturn;
import org.tizen.emulator.manager.ui.dialog.MessageBox;
import org.tizen.emulator.manager.ui.dialog.MessageBoxButton;
import org.tizen.emulator.manager.ui.dialog.network.TapGuideDialogForMac;
import org.tizen.emulator.manager.ui.tabview.PropertyValue;
import org.tizen.emulator.manager.ui.tabview.STATE;
import org.tizen.emulator.manager.ui.tabview.controller.ComboViewController;
import org.tizen.emulator.manager.ui.tabview.controller.ViewItemController;
import org.tizen.emulator.manager.ui.tabview.event.Event;
import org.tizen.emulator.manager.ui.tabview.event.ItemEvent;
import org.tizen.emulator.manager.ui.template.item.Item;

public class NetConnectTypeItemController
extends ComboViewController {
    private String connectType = "NAT";
    private static String LINUX_BRIDGE_WARNING = "A bridge network uses OpenVPN which has potential security vulnerabilities.";
    private static boolean showBridgeWarning = true;
    private static Boolean MANUAL_BRIDGE = null;

    public NetConnectTypeItemController(Item item) {
        super(item);
    }

    @Override
    protected void onChangedValue(Event event) {
        String oldType = this.connectType;
        String type = this.comboView.getSelectedItem();
        if (type != null && !type.isEmpty()) {
            this.connectType = type;
        }
        if (!oldType.equals(this.connectType)) {
            ItemEvent iEvent = new ItemEvent(this.getName(), this);
            iEvent.oldValue = oldType;
            iEvent.newValue = this.connectType;
            ViewItemController.sendChangeEvent(iEvent);
            if (this.connectType.equals("Bridge")) {
                if (OSUtil.isMac()) {
                    NetConnectTypeItemController.showGuideForMac();
                } else if (OSUtil.isLinux() && showBridgeWarning) {
                    String message = LINUX_BRIDGE_WARNING + StringResources.NEW_LINE + StringResources.NEW_LINE + "Do you want to continue anyway ?";
                    CheckReturn dialogResult = MessageBox.check(message, "Do not ask again and choose the bridge.", false, new MessageBoxButton(ButtonType.OK, "Continue"), new MessageBoxButton(ButtonType.CANCEL, "Back to NAT"));
                    if (dialogResult != null && dialogResult.getButtonType() == ButtonType.OK) {
                        showBridgeWarning = !dialogResult.isChecked();
                    } else {
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                NetConnectTypeItemController.this.comboView.selectItem("NAT");
                            }
                        });
                    }
                }
            }
            this.checkValid();
        }
    }

    @Override
    public void setIntializeValue(PropertyValue value) {
        String type = value.getStringValue(this.getName());
        if (type != null && !type.isEmpty()) {
            this.connectType = type;
            this.comboView.selectItem(this.connectType);
        } else {
            this.comboView.selectItem(this.connectType);
        }
        this.checkValid();
    }

    @Override
    public void setPropertyValue(PropertyValue value) {
        value.setStringValue(this.getName(), this.connectType);
    }

    @Override
    public void checkValid() {
        STATE newState = STATE.OK;
        String message = "";
        if (this.connectType.equals("Bridge") && OSUtil.isLinux()) {
            message = LINUX_BRIDGE_WARNING;
            newState = STATE.WARNING;
        }
        this.setItemState(newState, message);
    }

    private static void showGuideForMac() {
        if (MANUAL_BRIDGE == null) {
            MANUAL_BRIDGE = NetworkUtil.isBridgeGuideNecessaryForMac();
        }
        if (!MANUAL_BRIDGE.booleanValue()) {
            return;
        }
        if (!NetworkUtil.getBridgeNameForMac().isEmpty()) {
            return;
        }
        String message = Messages.getString("NetConnectTypeItem.showGuideForMac.1") + StringResources.NEW_LINE + Messages.getString("NetConnectTypeItem.showGuideForMac.2");
        ButtonType returnType = MessageBox.confirm(message);
        if (returnType == ButtonType.OK) {
            TapGuideDialogForMac.open();
        }
    }
}

