/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.dialog;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Window;
import org.tizen.emulator.manager.concurrent.SimpleExecutor;
import org.tizen.emulator.manager.concurrent.TaskCompletionListener;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.resources.StringResources;
import org.tizen.emulator.manager.tool.OSUtil;
import org.tizen.emulator.manager.ui.Main;
import org.tizen.emulator.manager.ui.controller.create.CreateDialog;
import org.tizen.emulator.manager.ui.controller.create.PlatformInstallationDialogController;
import org.tizen.emulator.manager.ui.dialog.CustomDialog;
import org.tizen.emulator.manager.ui.dialog.MessageBox;
import org.tizen.emulator.manager.vms.helper.HelperClass;
import org.tizen.emulator.manager.vms.helper.ProcessResult;

public class PlatformInstallDialog {
    private static Double WIDTH = 630.0;
    private PlatformInstallationDialogController controller;
    private static CustomDialog<ButtonType> dialog;
    private AnchorPane root;
    private static CustomDialog<ButtonType> askDialog;
    private static CustomDialog<ButtonType> launchingDialog;
    public static boolean dialogClosed;
    private static final URL VIEW_CSS;
    private static TaskCompletionListener<Boolean> launchCompletionListener;

    public PlatformInstallDialog() {
        this.makeContent();
    }

    public static void processPlatformInstall(Window parent) {
        new PlatformInstallDialog().open(parent);
    }

    public static void launchPackageManager(List<String> selectedPlatform) {
        StringBuilder sb = new StringBuilder();
        for (String str : selectedPlatform) {
            sb.append(str).append(",");
        }
        sb.deleteCharAt(sb.length() - 1);
        final String installPackageList = sb.toString();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (dialog != null) {
                    dialog.close();
                }
                launchingDialog = new CustomDialog();
                launchingDialog.setContentText("Launching the Package Manager...");
                launchingDialog.setTitle("Emulator Manager");
                launchingDialog.show();
            }
        });
        EMLogger.getLogger().info("Launching the package manager..");
        SimpleExecutor.asynExecute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                String packageManagerBinary = OSUtil.isWin() ? "package-manager.exe" : "package-manager.bin";
                ArrayList<String> cmd = new ArrayList<String>();
                cmd.add(FilePathResources.getTizenSDKPackageManagerPath() + File.separator + packageManagerBinary);
                cmd.add("--automatic-installation");
                cmd.add(installPackageList);
                cmd.add("--caller-tool");
                cmd.add("emulator-manager");
                File workingDir = new File(FilePathResources.getTizenSDKPackageManagerPath());
                ProcessResult result = HelperClass.runProcess(cmd, workingDir, false);
                if (!result.isStartedSuccessfully()) {
                    final String resultMessage = result.getResultMessage();
                    EMLogger.getLogger().warning("Failed to launch the package-manager.");
                    EMLogger.getLogger().warning(resultMessage);
                    Platform.runLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (launchingDialog != null) {
                                launchingDialog.setResult(ButtonType.OK);
                                launchingDialog.close();
                                launchingDialog = null;
                            }
                            MessageBox.error("Failed to launch the package-manager.\n" + resultMessage);
                        }
                    });
                    return false;
                }
                return true;
            }
        }, launchCompletionListener);
    }

    private void makeContent() {
        FXMLLoader loader = new FXMLLoader(CreateDialog.class.getResource("/view/create/platformInstallationDialogView.fxml"));
        try {
            this.root = (AnchorPane)loader.load();
            this.controller = (PlatformInstallationDialogController)loader.getController();
        }
        catch (IOException e) {
            e.printStackTrace();
            EMLogger.getLogger().warning(e.getMessage());
        }
        this.root.getStylesheets().add((Object)VIEW_CSS.toExternalForm());
    }

    public void open(Window parent) {
        dialog = new CustomDialog();
        dialog.setTitle("Platform Installation");
        dialog.getDialogPane().setContent((Node)this.root);
        dialog.getDialogPane().getButtonTypes().add((Object)ButtonType.OK);
        dialog.getDialogPane().getButtonTypes().add((Object)ButtonType.CANCEL);
        dialog.setResizable(true);
        dialog.getDialogPane().setMinSize(WIDTH.doubleValue(), 550.0);
        Button okButton = (Button)dialog.getDialogPane().lookupButton(ButtonType.OK);
        okButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (event.isConsumed()) {
                    return;
                }
                askDialog = new CustomDialog();
                askDialog.setContentText("Launching the Package Manager closes the Emulator Manager." + StringResources.NEW_LINE + StringResources.NEW_LINE + "Do you want to continue?");
                askDialog.setTitle("Emulator Manager");
                askDialog.getDialogPane().getButtonTypes().add((Object)ButtonType.YES);
                askDialog.getDialogPane().getButtonTypes().add((Object)ButtonType.NO);
                Optional buttonType = askDialog.showAndWait();
                if (buttonType == null || !buttonType.isPresent() || buttonType.get() == ButtonType.NO) {
                    return;
                }
                PlatformInstallDialog.launchPackageManager(PlatformInstallDialog.this.controller.getSelectedPackages());
            }
        });
        this.controller.setOKButton((Button)dialog.getDialogPane().lookupButton(ButtonType.OK));
        this.controller.tryGettingPlatformList(true);
        this.root.layout();
        dialog.setX(parent.getX() + parent.getWidth() / 2.0 - WIDTH / 2.0);
        dialog.setY(parent.getY() + 80.0);
        dialogClosed = false;
        dialog.showAndWait();
        dialogClosed = true;
        this.controller.destroySdkUtilProcess();
    }

    static {
        askDialog = null;
        launchingDialog = null;
        VIEW_CSS = PlatformInstallDialog.class.getResource("/view/create/platformInstallDialogView.css");
        launchCompletionListener = new TaskCompletionListener<Boolean>(){

            @Override
            public void completed(Boolean launchSuccess) {
                EMLogger.getLogger().info("Package manager launched. Result : " + launchSuccess);
                if (!launchSuccess.booleanValue()) {
                    return;
                }
                try {
                    Thread.sleep(2500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Main.getPrimaryStage().close();
                    }
                });
            }
        };
    }
}

