/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.tabview.event;

import java.util.HashMap;
import java.util.Map;
import org.tizen.emulator.manager.ui.tabview.event.EventHandler;
import org.tizen.emulator.manager.ui.tabview.event.EventHandlerList;

public class EventDispatcher<S, T> {
    private final Map<S, EventHandlerList<T>> handlerMap = new HashMap<S, EventHandlerList<T>>();

    public final void addEventHandler(S type, EventHandler<T> eventHandler) {
        EventHandlerList<T> handler = this.createGetCompoisteEventHandler(type);
        handler.addEventHandler(eventHandler);
    }

    public final void removeEventHandler(S type, EventHandler<T> eventHandler) {
        EventHandlerList<T> handler = this.handlerMap.get(type);
        if (handler != null) {
            handler.removeEventHandler(eventHandler);
        }
    }

    public final void sendEvent(S type, T event) {
        this.dispatchEvent(type, event);
    }

    public final void clear() {
        this.handlerMap.clear();
    }

    private T dispatchEvent(S type, T event) {
        EventHandlerList<T> compositeEventHandler = this.handlerMap.get(type);
        if (compositeEventHandler != null) {
            compositeEventHandler.dispatchEvent(event);
        }
        return event;
    }

    private EventHandlerList<T> createGetCompoisteEventHandler(S type) {
        EventHandlerList<T> handler = this.handlerMap.get(type);
        if (handler == null) {
            handler = new EventHandlerList();
            this.handlerMap.put(type, handler);
        }
        return handler;
    }
}

