/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.console;

import java.io.File;
import org.tizen.emulator.manager.console.Command;
import org.tizen.emulator.manager.console.Option;
import org.tizen.emulator.manager.console.resources.Messages;
import org.tizen.emulator.manager.console.resources.StringResources;
import org.tizen.emulator.manager.console.util.RemoteManagerCLI;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.tool.RemoteManager;

class RemoteLaunch
extends Command {
    public RemoteLaunch() {
        this.command = "remote-launch";
        this.description = Messages.getString("ActionList.RemoteLaunch.0");
        this.usage = Messages.getString("ActionList.RemoteLaunch.1");
        this.optionList.add(new Option("n", "name", StringResources.DESC_LAUNCH_NAME, "", true, true));
        this.optionList.add(new Option("p", "custom-path", StringResources.DESC_LAUNCH_PATH, FilePathResources.getPlatformsPath() + File.separator + "tizen-[VERSION]" + File.separator + "common" + File.separator + "emulator" + File.separator + "bin", false, true));
        this.optionList.add(new Option("s", "spice", StringResources.DESC_SPICE_PORT, "", false, false));
        this.optionList.add(new Option("u", "user-account", StringResources.DESC_USER_ACCOUNT, "", true, true));
        this.optionList.add(new Option("e", "ip", StringResources.DESC_IP, "", true, true));
        this.optionList.add(new Option("l", "sdk-path-num", StringResources.DESC_SDK_PATH_NUM, "", false, true));
    }

    @Override
    public boolean process() {
        String name = null;
        String path = null;
        boolean isTest = false;
        for (Option c : this.optionList) {
            if (!c.isInCommandLine()) continue;
            switch (c.getShortName().charAt(0)) {
                case 'n': {
                    if (c.getCurrentValue().equals("")) break;
                    name = c.getCurrentValue();
                    break;
                }
                case 'p': {
                    if (c.getCurrentValue().equals("")) break;
                    path = c.getCurrentValue();
                    break;
                }
                case 's': {
                    RemoteManager.setSpiceMode(true);
                    break;
                }
                case 'e': {
                    RemoteManager.setRemoteIp(c.getCurrentValue());
                    break;
                }
                case 'u': {
                    RemoteManager.setRemoteUserAccount(c.getCurrentValue());
                    break;
                }
                case 'l': {
                    RemoteManager.setSDK_pathNum(c.getCurrentValue());
                    break;
                }
                case 't': {
                    if (c.getCurrentValue().equals("")) break;
                    isTest = true;
                }
            }
        }
        RemoteManagerCLI remoteManager = new RemoteManagerCLI();
        if (RemoteManager.getSpiceMode()) {
            return remoteManager.launchRemoteEmulator(name, path, isTest);
        }
        return false;
    }
}

