/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.vms;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Queue;
import javax.xml.bind.JAXBException;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.resources.FilePathResources;
import org.tizen.emulator.manager.vms.VMKeeper;
import org.tizen.emulator.manager.vms.VMProperty;

public class DisposableVMKeeper
extends VMKeeper {
    @Override
    public void initialize() {
    }

    @Override
    public VMProperty getProperty(String name) {
        Path vmPath = Paths.get(FilePathResources.getTizenSDKDataVmsPath() + File.separator + name, new String[0]);
        if (!Files.exists(vmPath, new LinkOption[0])) {
            return null;
        }
        try {
            DirectoryStream<Path> stream = Files.newDirectoryStream(vmPath, "vm_config.xml");
            for (Path path : stream) {
                if (!Files.isRegularFile(path, new LinkOption[0])) continue;
                VMProperty property = this.loadProperty(path);
                if (property == null) {
                    return null;
                }
                this.listChanged(property, VMKeeper.ChangeType.ADDED);
                return property;
            }
        }
        catch (IOException e) {
            EMLogger.printStackTrace(e);
        }
        return null;
    }

    @Override
    public Queue<VMProperty> getProperties() {
        Path vmsPath = Paths.get(FilePathResources.getTizenSDKDataVmsPath(), new String[0]);
        assert (Files.exists(vmsPath, new LinkOption[0]));
        final LinkedList<VMProperty> properties = new LinkedList<VMProperty>();
        try {
            Files.walkFileTree(vmsPath, Collections.emptySet(), 2, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    try {
                        DirectoryStream<Path> stream = Files.newDirectoryStream(dir, "vm_config.xml");
                        for (Path path : stream) {
                            VMProperty property;
                            if (!Files.isRegularFile(path, new LinkOption[0]) || (property = DisposableVMKeeper.this.loadProperty(path)) == null) continue;
                            DisposableVMKeeper.this.listChanged(property, VMKeeper.ChangeType.ADDED);
                            properties.add(property);
                        }
                    }
                    catch (IOException e) {
                        EMLogger.printStackTrace(e);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            EMLogger.printStackTrace(e);
        }
        return properties;
    }
}

