/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.ui.item;

import java.util.Optional;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.util.Callback;
import org.tizen.emulator.manager.ui.controller.create.VMDialogData;
import org.tizen.emulator.manager.ui.controller.create.VMDialogPage;
import org.tizen.emulator.manager.ui.dialog.CustomDialog;
import org.tizen.emulator.manager.ui.item.VMItem;
import org.tizen.emulator.manager.ui.tabview.MODE;
import org.tizen.emulator.manager.ui.tabview.TabViewer;
import org.tizen.emulator.manager.vms.VMPropertyValue;

class ModifyDialog {
    private CustomDialog<VMPropertyValue> dialog;
    private Button okButton;
    private VMDialogPage propertyPage;
    private VMItem selectedItem;
    private VMDialogData data;
    private final BooleanProperty isInvalid = new SimpleBooleanProperty(false){

        protected void invalidated() {
            ModifyDialog.this.okButton.setDisable(ModifyDialog.this.isInvalid.get());
            if (!ModifyDialog.this.isInvalid.get()) {
                ModifyDialog.this.okButton.setDefaultButton(true);
            }
        }
    };

    public ModifyDialog(VMItem item) {
        this.selectedItem = item;
        this.dialog = new CustomDialog();
        this.dialog.setResizable(true);
        this.dialog.setTitle("Emulator Configuration");
        this.dialog.getDialogPane().getButtonTypes().add((Object)ButtonType.OK);
        this.dialog.getDialogPane().getButtonTypes().add((Object)ButtonType.CANCEL);
        this.dialog.getDialogPane().setMinSize(500.0, 450.0);
        this.okButton = (Button)this.dialog.getDialogPane().lookupButton(ButtonType.OK);
        this.propertyPage = new TabViewer();
        this.dialog.getDialogPane().setContent(this.propertyPage.getNode());
        this.dialog.setResultConverter((Callback)new Callback<ButtonType, VMPropertyValue>(){

            public VMPropertyValue call(ButtonType param) {
                if (param == ButtonType.CANCEL) {
                    return null;
                }
                ModifyDialog.this.propertyPage.setData(ModifyDialog.this.data);
                return ModifyDialog.this.data.getVmValue();
            }
        });
    }

    public VMPropertyValue open() {
        if (this.selectedItem != null) {
            this.data = this.selectedItem.getDialogData();
            this.data.setMode(MODE.MODIFY);
            this.propertyPage.onPageShow(this.data, (SimpleBooleanProperty)this.isInvalid);
            Optional optType = this.dialog.showAndWait();
            if (optType.isPresent()) {
                return (VMPropertyValue)optType.get();
            }
            return null;
        }
        return null;
    }
}

