/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.devices;

import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import org.tizen.emulator.manager.device.xml.template.DeviceConfiguration;
import org.tizen.emulator.manager.devices.CommonDeviceTemplateList;
import org.tizen.emulator.manager.devices.DeviceTemplate;
import org.tizen.emulator.manager.devices.DeviceTemplatePriority;
import org.tizen.emulator.manager.devices.DeviceTemplateValue;
import org.tizen.emulator.manager.logging.EMLogger;
import org.tizen.emulator.manager.platform.Platform;
import org.tizen.emulator.manager.platform.Skin;
import org.tizen.emulator.manager.tool.JAXBHelper;

public class DeviceTemplateUtil {
    public static void reloadDeviceTemplate(Platform platform) {
        CommonDeviceTemplateList.loadTemplates();
        platform.loadDeviceTemplates();
    }

    public static Set<String> getDeviceTemplateNameList(Platform platform) {
        HashSet<String> list = new HashSet<String>();
        for (DeviceTemplate template : CommonDeviceTemplateList.getDeviceTemplateList(false)) {
            list.add(template.getValue().getName());
        }
        if (platform == null) {
            return list;
        }
        for (DeviceTemplate template : platform.getDeviceTemplates()) {
            list.add(template.getValue().getName());
        }
        return list;
    }

    public static List<DeviceTemplate> getDeviceTemplateListByPlatform(Platform platform) {
        ArrayList<DeviceTemplate> list = new ArrayList<DeviceTemplate>();
        for (DeviceTemplate template : platform.getAvailableDeviceTemplates(true)) {
            list.add(template);
            DeviceTemplateUtil.setTemplateSkin(template.getValue(), platform);
        }
        return list;
    }

    public static void setTemplateSkin(DeviceTemplateValue value, Platform platform) {
        Skin skin = value.getSkin();
        if (skin == null) {
            SortedSet<Skin> skins = platform.getSkinList(value.getResolution());
            if (!skins.isEmpty()) {
                skin = skins.first();
                value.setSkinByManager(skin);
            }
        } else {
            value.setSkinByManager(skin);
        }
    }

    public static DeviceTemplate findDeviceTemplate(String path, Platform platform) {
        File target = new File(path);
        for (DeviceTemplate template : platform.getAvailableDeviceTemplates(false)) {
            if (!template.getTemplateFile().equals(target)) continue;
            return template;
        }
        return null;
    }

    public static DeviceTemplate findDeviceTemplateByName(String name, Platform platform) {
        for (DeviceTemplate template : platform.getAvailableDeviceTemplates(false)) {
            if (!template.getValue().getName().equals(name)) continue;
            return template;
        }
        return null;
    }

    public static DeviceTemplate findDefaultTemplate(Platform platform) {
        SortedSet<DeviceTemplate> templateList = platform.getAvailableDeviceTemplates(false);
        for (DeviceTemplate template : templateList) {
            if (template.getValue().getPriority() != DeviceTemplatePriority.DEFAULT) continue;
            return template;
        }
        return templateList.size() == 0 ? null : templateList.first();
    }

    public static void reloadDeviceConfiguration(DeviceTemplate template) {
        DeviceConfiguration conf = JAXBHelper.parseXML(template.getTemplateFile().toPath(), DeviceConfiguration.class);
        template.setConf(conf);
    }

    public static boolean saveDeviceConfiguration(DeviceConfiguration conf, File outputFile) {
        if (!outputFile.exists() && outputFile.getParentFile() != null) {
            outputFile.getParentFile().mkdirs();
        }
        if (!JAXBHelper.storeXML(outputFile.toPath(), conf)) {
            EMLogger.getLogger().warning("Failed to save device template file - " + outputFile.getName());
            return false;
        }
        return true;
    }

    public static void loadTemplates(String dirPath, SortedSet<DeviceTemplate> deviceList) {
        File deviceDir = new File(dirPath);
        if (!deviceDir.exists() || !deviceDir.isDirectory()) {
            return;
        }
        DeviceTemplate property = null;
        File[] devices = deviceDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                if (!file.isFile()) {
                    return false;
                }
                return !file.isHidden();
            }
        });
        if (devices == null) {
            return;
        }
        for (File device : devices) {
            if (!device.getAbsolutePath().endsWith("xml")) continue;
            DeviceConfiguration conf = JAXBHelper.parseXML(device.toPath(), DeviceConfiguration.class);
            if (conf != null) {
                property = new DeviceTemplate(device, conf);
                deviceList.add(property);
                continue;
            }
            EMLogger.getLogger().warning("Failed to load device template file - " + device.getName());
        }
    }
}

