/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.emulator.manager.platform;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;
import org.tizen.emulator.manager.vms.SkinShapeList;
import org.tizen.emulator.manager.vms.type.RESOLUTION;
import org.tizen.emulator.manager.vms.type.SKIN_SHAPE;
import org.tizen.emulator.manager.vms.type.SKIN_TYPE;

public class Skin
implements Comparable<Skin> {
    private String name;
    private RESOLUTION resolution = null;
    private String path;
    private SKIN_TYPE type;
    private int priorty = 5;
    private String profile;
    private SkinShapeList skinShapeList;

    public Skin(File path) throws IOException {
        this.loadProperty(path);
    }

    private void loadProperty(File path) throws IOException {
        block18: {
            this.path = path.getCanonicalPath();
            File infoFile = new File(path + File.separator + "info.ini");
            if (!infoFile.exists()) {
                throw new IOException("info.ini file does not exist.");
            }
            try (FileInputStream inputStream = new FileInputStream(infoFile);){
                Properties prop = new Properties();
                prop.load(inputStream);
                this.name = prop.getProperty("skin.name");
                String width = prop.getProperty("resolution.width");
                String height = prop.getProperty("resolution.height");
                this.priorty = Integer.valueOf(prop.getProperty("manager.priority", "5"));
                this.profile = prop.getProperty("skin.profile", "all");
                this.skinShapeList = SkinShapeList.create(prop.getProperty("skin.shape", "square"));
                String re = "";
                if (width.equals("all") && height.equals("all")) {
                    this.type = SKIN_TYPE.GENERAL;
                } else {
                    this.type = SKIN_TYPE.PROFILE_SPECIFIC;
                    re = width + "x" + height;
                }
                if (this.type != SKIN_TYPE.PROFILE_SPECIFIC) break block18;
                for (RESOLUTION r : RESOLUTION.values()) {
                    if (!r.getStrValue().equals(re)) continue;
                    this.resolution = r;
                }
                if (this.resolution != null) break block18;
                try {
                    this.resolution = new RESOLUTION(Integer.valueOf(width), Integer.valueOf(height), "", 316);
                }
                catch (NumberFormatException e) {
                    throw new IOException("This resolution is not supported ( + " + re + ")");
                }
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public RESOLUTION getResolution() {
        return this.resolution;
    }

    public String getPath() {
        return this.path;
    }

    public SkinShapeList getSkinShapeList() {
        return this.skinShapeList;
    }

    @Deprecated
    public SKIN_SHAPE getSkinShape() {
        if (this.skinShapeList != null && this.skinShapeList.size() > 0) {
            return this.skinShapeList.get(0);
        }
        return SKIN_SHAPE.NONE;
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Skin)) {
            return false;
        }
        return ((Skin)obj).getPath().equals(this.path);
    }

    public SKIN_TYPE getType() {
        return this.type;
    }

    public int getPriorty() {
        return this.priorty;
    }

    public String getProfile() {
        return this.profile;
    }

    @Override
    public int compareTo(Skin target) {
        if (this.priorty <= target.priorty) {
            return -1;
        }
        return 1;
    }
}

